<?php
	 /*
	  JNIOR Monitor/Configuration Page
	  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
	  724.933.9350
	  
	  File: config.css.php
	  
	  This file contains the dynamic CSS Stylesheet for the main page. JANOS server-side
	  scripting is used to customize specific style classes as required by the unit's
	  configuration.
	  
	  The user is hereby granted license to use, modify, and redistribute the contents of this
	  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
	  Group, Inc. is required.
	*/

	// We need to define the type for the server.
	header("Content-Type: text/css");
	
	// Fetch possible custom colors
	$on = getRegistryString("IO/OnColor", "#66ff66");
	$off = getRegistryString("IO/OffColor", "#ff6666");

	// Inverts the I/O status colors
	if (getRegistryBoolean("IO/InvertColors")) {
		echo "div.state.on \{ background:$off; }\r\n";
		echo "div.fbstate.on \{ background:$off; }\r\n";
		echo "div.state.off \{ background:$on; }\r\n";
		echo "div.fbstate.off \{ background:$on; }\r\n";
	}
	else {
		echo "div.state.on \{ background:$on; }\r\n";
		echo "div.fbstate.on \{ background:$on; }\r\n";
		echo "div.state.off \{ background:$off; }\r\n";
		echo "div.fbstate.off \{ background:$off; }\r\n";
	}
?>
