 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: inputs.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Function returns HTML for the 8DIN module
function device_inputs(key) {
	var id = module_keyToId[key];
	
	var status = module_idToStatus[id];
	if (status === undefined)
		return;	
		
	var states = parseInt(status.substring(6, 8), 16);
	
	var id = module_keyToId[key];
	var modkey = "externals/" + id.toLowerCase() + "/";
	var desc_key = modkey + "Desc";
	var desc = getkey(desc_key, "Digital 8DIN");

	var inner = "<td name='f8'>";
	inner += "<p class='modname' name='" + keystd(desc_key) + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='dinio'>";
	
	inner += "<table class='relayleft'>";

	for (var n = 0; n < 8; n++) {
		var chkey = modkey + "Din" + (n + 1) + "/";
		var idn = "din" + n + ":" + id;

		// get relay configuration details
		var desc_key = chkey + "Desc";
		var desc_val = getkey(desc_key, "Digital Input " + (n + 1));
		var on_key = chkey + "OnText";
		var on_val = getkey(on_key, "ON");
		var off_key = chkey + "OffText";
		var off_val = getkey(off_key, "OFF");
		var enab_key = chkey + "Enable";
		var enab_val = istrue(getkey(enab_key, "enabled"));
		
		if (n == 4)
			inner += "</table><table class='relayright'>";
			
		inner += "<tr><td>";
		if (enab_val) {
			inner += "<div class='fbname'>";
			inner += "<div name='" + keystd(desc_key) + "'>" + desc_val + "</div></div>";
		
			// display state
			var state = states & (1 << n);
			if (state) 
				inner += "<div class='fbstate on' id='" + idn + "' name='" + keystd(on_key) + "'>" + on_val + "</div>";
			else 
				inner += "<div class='fbstate off' id='" + idn + "' name='" + keystd(off_key) + "'>" + off_val + "</div>";
		}
		inner += "</td></tr>";
	}
	
	inner += "</table>";
	inner += "</div>";
	inner += "</td>";
	return inner;
}

// Function updates 8DIN Module block content
function update_inputs(key) {
	var id = module_keyToId[key];
	
	var status = module_idToStatus[id];
	if (status === undefined)
		return;	

	var states = parseInt(status.substring(6, 8), 16);
	
	var modkey = "Externals/" + id + "/";

	// update input status
	for (var n = 0; n < 8; n++) {
		var chkey = modkey + "Din" + (n + 1)+ "/";
		var idn = "din" + n + ":" + id;

		var on_key = chkey + "OnText";
		var on_val = getkey(on_key, "ON");
		var off_key = chkey + "OffText";
		var off_val = getkey(off_key, "OFF");
		
		var elem = document.getElementById(idn);
		if (elem) {

			// fetch I/O state
			state = states & (1 << n);
			
			elem.className = state != 0 ? "fbstate on" : "fbstate off";
			elem.name = state != 0? keystd(on_key) : keystd(off_key);
			elem.innerHTML = state != 0 ? on_val : off_val;	
		}
	}

	return false;
}
