/*
 * Decompiled with CFR 0.152.
 */
package com.integ;

import com.integ.ParameterGroups;
import com.integpg.sensor.SensorPort;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.ArrayList;

public class ControlPanel {
    private static final String USAGE_STRING = "CONTROLPANEL\n\nOptions:\r\n  -VOLUME volume     Sets the volume level to a value between 0% and 100%\n\nSet options for the control panel";

    public static void main(String[] args) {
        ParameterGroups parameters = new ParameterGroups(args);
        if (parameters.isEmpty() || parameters.containsParameterGroup("help")) {
            System.out.println(USAGE_STRING);
            return;
        }
        block8: while (parameters.hasMoreParameters()) {
            String parameterGroupName = parameters.getNextParameterGroup();
            ArrayList<String> parameterOptions = parameters.getParameterOptions(parameterGroupName);
            switch (parameterGroupName) {
                case "volume": {
                    try {
                        ControlPanel.processSetVolume(parameterOptions);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                    continue block8;
                }
            }
            System.out.println("unknown parameter: " + parameterGroupName);
            return;
        }
    }

    private static long[] getExternalAddresses() {
        try {
            return SensorPort.externalDeviceList();
        }
        catch (IOException ex) {
            throw new RuntimeException("unable to get external device list.");
        }
    }

    private static String getAddressString(long address) {
        String addressString = "0000000000000000" + Long.toHexString(address);
        return addressString.substring(addressString.length() - 16);
    }

    private static void processSetVolume(ArrayList<String> options) {
        int volume;
        if (0 == options.size()) {
            throw new RuntimeException("must specify a volume parameter between 0% and 100%.");
        }
        try {
            volume = Double.valueOf(options.get(0)).intValue();
            if (0 > volume || 100 < volume) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("invalid volume specified: '" + options.get(0) + "', volume parameter must be between 0% and 100%.");
        }
        for (long externalModuleAddress : ControlPanel.getExternalAddresses()) {
            String addressString = ControlPanel.getAddressString(externalModuleAddress).toUpperCase();
            if (250L != (externalModuleAddress & 0xFFL)) continue;
            try {
                byte[] writeBlock = ControlPanel.getSetVolumeWriteBlock((int)((double)volume * 2.55));
                SensorPort.writeDeviceBlock((long)externalModuleAddress, (byte[])writeBlock);
                String result = String.format("Panel at %s set volume to %d percent", addressString, volume);
                System.out.println(result);
                JANOS.syslog((String)result);
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("unable to write to the control panel: %s.", addressString));
            }
        }
    }

    private static byte[] getSetVolumeWriteBlock(int volume) {
        byte[] bytes = new byte[20];
        bytes[10] = 4;
        bytes[11] = (byte)volume;
        return bytes;
    }
}

