/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.internalio;

import com.integpg.janoslib.internalio.IOChangedListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.JANOS;
import java.util.EventObject;
import java.util.Vector;

public class IOMonitor
implements Runnable {
    private static Thread _thd = null;
    private static Vector _listeners = new Vector();
    private static int _changedInputs;
    private static int _inputStates;
    private static int _changedOutputs;
    private static int _outputStates;
    private static int _sleepTime;

    private IOMonitor() {
    }

    public static void addListener(IOChangedListener listener) {
        _listeners.addElement(listener);
        AppLog.info("IO Monitor listener added");
    }

    public static void start() {
        if (_thd == null) {
            _thd = new Thread(new IOMonitor());
            _thd.setDaemon(true);
            _thd.setName("Monitor Internal IO");
            _thd.start();
        }
    }

    public static void setScanRate(int sleepTime) {
        _sleepTime = sleepTime;
    }

    public static int getInputStates() {
        return _inputStates;
    }

    public static int getChangedInputs() {
        return _changedInputs;
    }

    public static int getOutputStates() {
        return _outputStates;
    }

    public static int getChangedOutputs() {
        return _changedOutputs;
    }

    @Override
    public void run() {
        AppLog.info("IO Monitor started");
        int lastInputStates = JANOS.getInputStates();
        int lastOutputStates = JANOS.getOutputStates();
        try {
            while (true) {
                _inputStates = JANOS.getInputStates();
                _outputStates = JANOS.getOutputStates();
                _changedInputs = _inputStates ^ lastInputStates;
                _changedOutputs = _outputStates ^ lastOutputStates;
                if (_changedInputs != 0 || _changedOutputs != 0) {
                    lastInputStates = _inputStates;
                    lastOutputStates = _outputStates;
                    for (int i = 0; i < _listeners.size(); ++i) {
                        IOChangedListener listener = (IOChangedListener)_listeners.elementAt(i);
                        listener.ioChanged(new EventObject(this));
                    }
                }
                Thread.sleep(_sleepTime);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error in input state monitor: " + ex.getMessage());
            return;
        }
    }

    static {
        _sleepTime = 100;
    }
}

