/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messagepump;

import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.messagepump.RegistryModifiedListener;
import com.integpg.system.SystemMsg;
import java.util.ArrayList;

public class RegistryModifiedHandler
implements MessagePumpListener {
    private static final RegistryModifiedHandler INSTANCE = new RegistryModifiedHandler();
    private static final Logger LOG = Logger.getLogger();
    private static final ArrayList<RegistryModifiedListener> LISTENERS = new ArrayList();
    private static boolean AddedToMessgePump = false;

    private RegistryModifiedHandler() {
    }

    public static void addListener(RegistryModifiedListener listener) {
        LISTENERS.add(listener);
        LOG.info(String.format("   added registry handler = %s", listener.getClass().getName()));
        if (!AddedToMessgePump) {
            MessagePumpEngine.addListener(INSTANCE);
            MessagePumpEngine.start();
            AddedToMessgePump = true;
        }
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (64 == systemMsg.type) {
            String registryKey = new String(systemMsg.msg);
            for (RegistryModifiedListener listener : LISTENERS) {
                listener.registryModifiedEvent(registryKey);
            }
        }
    }
}

