/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbusserver;

import com.integ.modbusserver.ExternalModuleConfig;
import com.integ.modbusserver.ModbusComm;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.system.Immutable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class ModbusServer
implements Runnable {
    public static Immutable store = new Immutable();
    private static Thread theServer = null;
    private ServerSocket svrSocket;
    private Socket sock;
    public static Vector connections;
    public boolean bServerRun = true;
    int totalConnections = 0;

    public ModbusServer() {
        RegistryUtils.moveFolder("ModbusServer", "AppData/ModbusServer");
        RegistryUtils.moveFolder("AppData/Modbus_Server", "AppData/ModbusServer");
        FileUtils.moveFile("modbus_server.log", "modbusserver.log");
        FileUtils.moveFile("modbus_server.log.bak", "modbusserver.log.bak");
        FileUtils.moveFile("modbus_server_boot.log", "modbusserver_boot.log");
        FileUtils.moveFile("modbus_server_boot.log.bak", "modbusserver_boot.log.bak");
        FileUtils.moveFile("modbus_server_exception.log", "modbusserver_exception.log");
        FileUtils.moveFile("modbus_server_exception.log.bak", "modbusserver_exception.log.bak");
        FileUtils.moveFile("modbus_server_releasenotes.json", "modbusserver_releasenotes.json");
        ExternalModuleConfig.init();
        store = new Immutable();
        try {
            AppLog.info("open Modbus00");
            store.open("Modbus00");
            if (!store.isOpen()) {
                throw new IOException("store not open");
            }
        }
        catch (IOException ex) {
            AppLog.error("Error opening Modbus Data Store: " + ex.toString());
            try {
                AppLog.info("Create Modbus00");
                store.create("Modbus00", 8192);
                AppLog.info("Initialized Modbus Data Store");
            }
            catch (IOException ex2) {
                AppLog.error("Error Initializing Modbus Data Store: " + ex2.toString());
            }
        }
        try {
            AppLog.info("Get server port");
            int port = RegistryUtils.getRegistryKey("AppData/ModbusServer/Port", 502);
            this.svrSocket = new ServerSocket(port);
            AppLog.info("Listening on port " + port);
            RegistryUtils.getRegistryKey("AppData/ModbusServer/Login", true);
            RegistryUtils.getRegistryKey("AppData/ModbusServer/Timeout", 90000);
            connections = new Vector();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public synchronized void start() {
        if (theServer == null) {
            theServer = new Thread((Runnable)this, "Modbus Server");
            theServer.start();
            AppLog.info("MODBUS Server Started...");
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this.svrSocket.close();
        this.svrSocket = null;
        try {
            if (connections != null) {
                Enumeration connEnum = connections.elements();
                while (connEnum.hasMoreElements()) {
                    ModbusComm mc = (ModbusComm)connEnum.nextElement();
                    if (mc == null) continue;
                    mc.close("client disconnected: Modbus Server shutting down");
                }
            }
        }
        catch (IOException ex) {
            AppLog.error("Error stopping Modbus Server: " + ex.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.bServerRun) {
                try {
                    block19: {
                        try {
                            this.sock = this.svrSocket.accept();
                            ++this.totalConnections;
                            System.out.println("Accepted connection #" + this.totalConnections);
                        }
                        catch (IOException ex) {
                            if (!this.bServerRun) break block19;
                            AppLog.error("MODBUS server exception: " + ex.toString());
                            Thread.sleep(5000L);
                            continue;
                        }
                    }
                    if (this.sock == null) return;
                    if (!this.bServerRun) {
                        return;
                    }
                    ModbusComm modbus = new ModbusComm(this.sock);
                    Thread mThread = new Thread((Runnable)modbus, "Modbus Client " + this.sock.getPort());
                    mThread.start();
                    connections.addElement(modbus);
                    System.out.println("+++ CONNECTIONS: " + connections.size());
                }
                catch (RuntimeException ex) {
                    AppLog.error(ex.toString());
                    if (connections != null) {
                        while (connections.size() > 0) {
                            try {
                                ModbusComm mc = (ModbusComm)connections.elementAt(0);
                                if (mc == null) continue;
                                mc.close("client disconnected: Modbus Server exception thrown");
                            }
                            catch (IOException ex2) {
                                AppLog.error(ex2.toString());
                            }
                        }
                    }
                    try {
                        Thread.sleep(30000L);
                        if (this.svrSocket != null) {
                            this.svrSocket.close();
                        }
                        this.svrSocket = null;
                        if (!this.bServerRun) continue;
                        int port = RegistryUtils.getRegistryKey("AppData/ModbusServer/Port", 502);
                        this.svrSocket = new ServerSocket(port);
                    }
                    catch (InterruptedException ex1) {
                        AppLog.error(ex1.toString());
                    }
                    catch (IOException ex2) {
                        AppLog.error(ex2.toString());
                    }
                }
            }
            return;
        }
        catch (Exception ie) {
            try {
                if (this.svrSocket != null) {
                    this.svrSocket.close();
                }
                this.svrSocket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.bServerRun) return;
            AppLog.error(ie.toString());
        }
    }
}

