/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class Christie
extends TheatreEthernetDevice {
    private static final byte[] LOGIN_BYTES = "(UID \"\" \"\")".getBytes();
    private static final byte[] OPEN_DOWSER_BYTES = "(SHU 0)".getBytes();
    private static final byte[] CLOSE_DOWSER_BYTES = "(SHU 1)".getBytes();
    private static final byte[] LAMP_OFF_BYTES = "(PWR 0)".getBytes();
    private static final byte[] LAMP_ON_BYTES = "(PWR 1)".getBytes();

    public Christie(String name) {
        super(name);
        this.port = "5000";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        block22: {
            System.out.println("Christie macro: " + macroName);
            if (macroName.toLowerCase().equals("close dowser")) {
                try {
                    if (this.send(CLOSE_DOWSER_BYTES)) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Closing Dowser");
                        break block22;
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Error Closing Dowser");
                }
                catch (Exception ex) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Error Closing Dowser");
                }
            } else if (macroName.toLowerCase().equals("open dowser")) {
                try {
                    if (this.send(OPEN_DOWSER_BYTES)) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Opening Dowser");
                        break block22;
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Error Opening Dowser");
                }
                catch (Exception ex) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Error Opening Dowser");
                }
            } else if (macroName.toLowerCase().equals("lamp on")) {
                try {
                    if (this.send(LAMP_ON_BYTES)) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Lamp On");
                        break block22;
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Error Turning Lamp On");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp On");
                }
            } else if (macroName.toLowerCase().equals("lamp off")) {
                try {
                    if (this.send(LAMP_OFF_BYTES)) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Lamp Off");
                        break block22;
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Error Turning Lamp Off");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Lamp Off");
                }
            } else if (macroName.startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (data == null) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                this.send(dataBytes);
            }
        }
        return true;
    }

    public synchronized boolean send(byte[] dataBytes) {
        if (this.ensureConnection()) {
            try {
                if (dataBytes == null) {
                    System.out.println(this.name + " databytes null");
                }
                this.bos.reset();
                this.bos.write(dataBytes);
                this.out.write(this.bos.toByteArray());
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                try {
                    this.disconnect();
                    if (!this.ensureConnection()) {
                        this.disconnect();
                        return false;
                    }
                    this.out.write(this.bos.toByteArray());
                }
                catch (IOException ex2) {
                    FileLogger.error(ex2);
                    this.disconnect();
                    return false;
                }
            }
        } else {
            System.out.println("Could not connect");
            return false;
        }
        return true;
    }
}

