/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.webhandlers;

import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;
import java.util.Json;

class StatusJson {
    private static final Json Json = new Json();

    StatusJson() {
    }

    public Json getJson() {
        long uptimeSeconds = JANOS.uptimeMillis() / 1000L;
        Json.put("UptimeSeconds", uptimeSeconds);
        long days = uptimeSeconds / 86400L;
        long hours = uptimeSeconds % 86400L / 3600L;
        long minutes = uptimeSeconds % 3600L / 60L;
        long seconds = uptimeSeconds % 60L;
        if (7L < days) {
            long weeks = days / 7L;
            Json.put("UptimeString", (Object)String.format("%lld weeks, %lld days %02lld:%02lld:%02lld", weeks, days %= 7L, hours, minutes, seconds));
        } else {
            Json.put("UptimeString", (Object)String.format("%lld days %02lld:%02lld:%02lld", days, hours, minutes, seconds));
        }
        return Json;
    }

    static {
        Json.put("Hostname", (Object)UnitConfig.getHostname());
        Json.put("IpAddress", (Object)UnitConfig.getIpAddress());
        Json.put("Model", (Object)UnitConfig.MODEL);
        Json.put("SerialNumber", UnitConfig.SERIAL_NUMBER);
        Json.put("JANOSVersion", (Object)UnitConfig.VERSION);
        Json.put("CinemaVersion", (Object)Application.getAppVersion());
    }
}

