/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.RegistryModifiedListener;
import com.integpg.cinema.ScheduleTask;
import com.integpg.cinema.client.CinemaServerClient;
import com.integpg.cinema.client.PreshowClient;
import com.integpg.cinema.configuration.ScheduledConfig;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class Config
implements RegistryModifiedListener {
    private static final String APPDATA_ROOT = "AppData/Cinema";
    private static final String FILE_LOCATION_DEFAULT = "/";
    public static String FILE_LOCATION = "/";
    private static final String REG_LOAD_BALANCE_OUTPUT = "AppData/Cinema/IO/LoadBalanceOutput";
    private static final int LOAD_BALANCE_OUTPUT_DEFAULT = -1;
    public static int LOAD_BALANCE_OUTPUT = -1;
    private static final String REG_LOAD_BALANCE_TIME_OF_DAY = "AppData/Cinema/IO/LoadBalanceTimeOfDay";
    public static int LOAD_BALANCE_OFFSET = 0;
    private static final String REG_PRESHOW_LAMP_OUTPUT = "AppData/Cinema/IO/PreshowLampOutput";
    private static final int PRESHOW_LAMP_OUTPUT_DEFAULT = -1;
    public static int PRESHOW_LAMP_OUTPUT = -1;
    private static final String REG_MOVIE_STATUS_OUTPUT = "AppData/Cinema/IO/MovieStatusOutput";
    private static final int MOVIE_STATUS_OUTPUT_DEFAULT = -1;
    public static int MOVIE_STATUS_OUTPUT = -1;
    private static final String REG_PRESHOW_LOCK_OUTPUT = "AppData/Cinema/IO/PreshowLockOutput";
    private static final String REG_PRESHOW_LOCK_INVERT = "AppData/Cinema/IO/PreshowLockInvert";
    public static int PRESHOW_LOCK_OUTPUT = -1;
    public static boolean PRESHOW_LOCK_INVERT = false;
    private static final String REG_PRESHOW_START_PUSHBUTTON_INPUT = "AppData/Cinema/IO/PreshowStartPushButtonInput";
    private static final int PRESHOW_START_PUSHBUTTON_INPUT_DEFAULT = -1;
    public static int PRESHOW_START_PUSHBUTTON_INPUT = -1;
    private static final String REG_FEATURE_START_INPUT = "AppData/Cinema/IO/FeatureStartInput";
    private static final int FEATURE_START_INPUT_DEFAULT = -1;
    public static int FEATURE_START_INPUT = -1;
    private static final String REG_FIVE_MIN_TIMER = "AppData/Cinema/FiveMinutePreshowTimerEnabled";
    private static final boolean FIVE_MIN_TIMER_DEFAULT = false;
    public static boolean FIVE_MIN_TIMER = false;
    public static String COMMUNITY_NAME = "public";
    public static int REBOOT_TRAP_CLEAR_TIMEOUT_MINTUES = 30;
    private static final String REG_FIRE_ALARM_INPUT = "AppData/Cinema/IO/FireAlarmInput";
    public static int FIRE_ALARM_INPUT = -1;
    private static final String REG_FIRE_ALARM_RELEASE_INPUT = "AppData/Cinema/IO/FireAlarmReleaseInput";
    public static int FIRE_ALARM_RELEASE_INPUT = -1;
    private static final String REG_FIRE_ALARM_ACTIVE_TEXT = "AppData/Cinema/FireAlarmActiveText";
    public static String FIRE_ALARM_ACTIVE_TEXT = "Fire Alarm Active";
    private static final String REG_FIRE_ALARM_CLEAR_TEXT = "AppData/Cinema/FireAlarmClearText";
    public static String FIRE_ALARM_CLEAR_TEXT = "Fire Alarm Clear";
    private static final String REG_DELAYED_FIRE_ALARM_INPUT = "AppData/Cinema/IO/DelayedFireAlarmInput";
    public static final Vector LOGS = new Vector();
    public static String DEVICES_LOG = "cinema_devices.log";
    public static String MESSAGE_PUMP_LOG = "cinema_messagepump.log";
    public static boolean PREVENT_MULTIPLE_INSTANCES = true;
    private static final String REG_MOVIE_END_MACRO = "AppData/Cinema/MACROS/MovieEndMacro";
    private static final String MOVIE_END_MACRO_DEFAULT = "Movie End";
    public static String MOVIE_END_MACRO = "Movie End";
    private static final String REG_FIRE_ALARM_MACRO = "AppData/Cinema/MACROS/FireAlarmMacro";
    private static final String FIRE_ALARM_MACRO_DEFAULT = "Fire Alarm";
    public static String FIRE_ALARM_MACRO = "Fire Alarm";
    private static final String REG_FIRE_ALARM_MOVIE_CLEAR_MACRO = "AppData/Cinema/MACROS/FireAlarmMovieClearMacro";
    private static final String FIRE_ALARM_MOVIE_CLEAR_MACRO_DEFAULT = "Fire Alarm Movie Clear";
    public static String FIRE_ALARM_MOVIE_CLEAR_MACRO = "Fire Alarm Movie Clear";
    private static final String REG_FIRE_ALARM_PRESHOW_CLEAR_MACRO = "AppData/Cinema/MACROS/FireAlarmPreshowClearMacro";
    private static final String FIRE_ALARM_PRESHOW_CLEAR_MACRO_DEFAULT = "Fire Alarm Preshow Clear";
    public static String FIRE_ALARM_PRESHOW_CLEAR_MACRO = "Fire Alarm Preshow Clear";
    public static final String[] INPUT_TRIGGER_MACROS = new String[UnitConfig.getInputCount()];
    public static final String[] OUTPUT_TRIGGER_MACROS = new String[UnitConfig.getOutputCount()];
    public static final int[] INPUT_TRIGGER_DELAY_TIMES = new int[12];
    public static final String REG_CLIENT_IO_ENABLED = "AppData/Cinema/Client/SerialCommandsEnabled";
    public static boolean CLIENT_IO_ENABLED = false;
    public static final String REG_CLIENT_UNSOLICITED_IO = "AppData/Cinema/Client/UnsolicitedIoAlerts";
    public static boolean CLIENT_UNSOLICITED_IO = false;
    public static final String REG_CLIENT_SEND_COUNTS = "AppData/Cinema/Client/SendCounts";
    public static boolean CLIENT_SEND_COUNTS = false;
    public static int[] SLAVED_IO = new int[16];

    public static int getWebServerPort() {
        return RegistryUtils.getRegistryKey("AppData/Cinema/WebServer/Port", -1);
    }

    static int getUdpServerPortNumber() {
        return RegistryUtils.getRegistryKey(String.format("%s/UdpServerPortNumber", APPDATA_ROOT), -1);
    }

    public void getConfig() throws IOException {
        int length = FILE_LOCATION.length();
        if (length > 0 && FILE_LOCATION.charAt(length - 1) != '/') {
            FILE_LOCATION = FILE_LOCATION + '/';
        }
        LOAD_BALANCE_OUTPUT = RegistryUtils.getRegistryKey(REG_LOAD_BALANCE_OUTPUT, LOAD_BALANCE_OUTPUT);
        String loadBalanceTimeOfDay = RegistryUtils.getRegistryKey(REG_LOAD_BALANCE_TIME_OF_DAY, "0:00");
        int colonPos = loadBalanceTimeOfDay.indexOf(58);
        if (colonPos > 0) {
            int hour = Integer.parseInt(loadBalanceTimeOfDay.substring(0, colonPos));
            int minute = Integer.parseInt(loadBalanceTimeOfDay.substring(colonPos + 1));
            LOAD_BALANCE_OFFSET = (hour * 60 + minute) * 60;
        }
        PRESHOW_LAMP_OUTPUT = RegistryUtils.getRegistryKey(REG_PRESHOW_LAMP_OUTPUT, PRESHOW_LAMP_OUTPUT);
        MOVIE_STATUS_OUTPUT = RegistryUtils.getRegistryKey(REG_MOVIE_STATUS_OUTPUT, MOVIE_STATUS_OUTPUT);
        PRESHOW_LOCK_OUTPUT = RegistryUtils.getRegistryKey(REG_PRESHOW_LOCK_OUTPUT, PRESHOW_LOCK_OUTPUT);
        PRESHOW_LOCK_INVERT = RegistryUtils.getRegistryKey(REG_PRESHOW_LOCK_INVERT, PRESHOW_LOCK_INVERT);
        PRESHOW_START_PUSHBUTTON_INPUT = RegistryUtils.getRegistryKey(REG_PRESHOW_START_PUSHBUTTON_INPUT, PRESHOW_START_PUSHBUTTON_INPUT);
        FEATURE_START_INPUT = RegistryUtils.getRegistryKey(REG_FEATURE_START_INPUT, FEATURE_START_INPUT);
        FIVE_MIN_TIMER = RegistryUtils.getRegistryKey(REG_FIVE_MIN_TIMER, FIVE_MIN_TIMER);
        COMMUNITY_NAME = RegistryUtils.getRegistryKey("AppData/Cinema/SNMP/CommunityName", COMMUNITY_NAME);
        REBOOT_TRAP_CLEAR_TIMEOUT_MINTUES = RegistryUtils.getRegistryKey("AppData/Cinema/SNMP/RebootClearTimeoutMinutes", REBOOT_TRAP_CLEAR_TIMEOUT_MINTUES);
        FIRE_ALARM_INPUT = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_INPUT, FIRE_ALARM_INPUT);
        FIRE_ALARM_RELEASE_INPUT = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_RELEASE_INPUT, FIRE_ALARM_RELEASE_INPUT);
        FIRE_ALARM_ACTIVE_TEXT = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_ACTIVE_TEXT, FIRE_ALARM_ACTIVE_TEXT);
        FIRE_ALARM_CLEAR_TEXT = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_CLEAR_TEXT, FIRE_ALARM_CLEAR_TEXT);
        LOGS.addElement(PreshowClient.CLIENT_LOG);
        LOGS.addElement(CinemaServerClient.CINEMA_SERVER_LOG);
        LOGS.addElement(DEVICES_LOG);
        File projectorLog = new File("projector.log");
        if (projectorLog.exists() && projectorLog.renameTo(new File(DEVICES_LOG))) {
            JANOS.syslog((String)("Renamed projector.log to " + DEVICES_LOG));
        }
        if ((projectorLog = new File("projector.log.bak")).exists() && projectorLog.renameTo(new File(DEVICES_LOG + ".bak"))) {
            JANOS.syslog((String)("Renamed projector.log.bak to " + DEVICES_LOG + ".bak"));
        }
        projectorLog = null;
        PREVENT_MULTIPLE_INSTANCES = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreventMultipleInstances", true);
        MOVIE_END_MACRO = RegistryUtils.getRegistryKey(REG_MOVIE_END_MACRO, MOVIE_END_MACRO);
        FIRE_ALARM_MACRO = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_MACRO, FIRE_ALARM_MACRO);
        FIRE_ALARM_MOVIE_CLEAR_MACRO = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_MOVIE_CLEAR_MACRO, FIRE_ALARM_MOVIE_CLEAR_MACRO);
        FIRE_ALARM_PRESHOW_CLEAR_MACRO = RegistryUtils.getRegistryKey(REG_FIRE_ALARM_PRESHOW_CLEAR_MACRO, FIRE_ALARM_PRESHOW_CLEAR_MACRO);
        CLIENT_IO_ENABLED = RegistryUtils.getRegistryKey(REG_CLIENT_IO_ENABLED, CLIENT_IO_ENABLED);
        CLIENT_UNSOLICITED_IO = RegistryUtils.getRegistryKey(REG_CLIENT_UNSOLICITED_IO, CLIENT_UNSOLICITED_IO);
        CLIENT_SEND_COUNTS = RegistryUtils.getRegistryKey(REG_CLIENT_SEND_COUNTS, CLIENT_SEND_COUNTS);
        String[] keys = JANOS.getRegistryList((String)"AppData/Cinema/Slaving");
        int keyCount = keys.length;
        for (int i = 0; i < keyCount; ++i) {
            String value = RegistryUtils.getRegistryKey("AppData/Cinema/Slaving/" + keys[i], "");
            if (value.equals("")) continue;
            try {
                StringTokenizer st = new StringTokenizer(value, ":");
                int output = Integer.parseInt(st.nextToken());
                int input = Integer.parseInt(st.nextToken());
                Config.SLAVED_IO[output - 1] = input;
                continue;
            }
            catch (Exception ex) {
                FileLogger.error("Slaving key: " + keys[i] + ", is in the incorrect format", ex);
            }
        }
        RegistryUtils.getRegistryKey("AppData/Cinema/Schedule/ScheduleRule1", "none");
        RegistryUtils.getRegistryKey("AppData/Cinema/Schedule/ScheduleRule2", "none");
        RegistryUtils.getRegistryKey("AppData/Cinema/Schedule/ScheduleRule3", "none");
        this.loadSchedulesConfig();
        this.loadTriggerConfig();
    }

    private void loadSchedulesConfig() {
        CinemaMain.TIMER.cancel();
        CinemaMain.TIMER = new Timer(true);
        System.out.println("Get scheduled events");
        String[] keys = JANOS.getRegistryList((String)"AppData/Cinema/Schedule");
        int keyCount = keys.length;
        for (int i = 0; i < keyCount; ++i) {
            String[] values = RegistryUtils.getRegistryKeys("AppData/Cinema/Schedule/" + keys[i], "");
            try {
                FileLogger.info("Load schedule: " + keys[i]);
                ScheduledConfig config = ScheduledConfig.parse(values);
                if (config == null) continue;
                ScheduleTask scheduleTask = new ScheduleTask(config);
                System.out.println("first trigger time: " + config.getStartTime());
                CinemaMain.TIMER.schedule((TimerTask)scheduleTask, config.getStartTime(), config.getInterval());
                continue;
            }
            catch (Exception ex) {
                FileLogger.error("Schedule key: " + keys[i] + ", is in the incorrect format", ex);
            }
        }
    }

    @Override
    public void registryModified(String key) {
        System.out.println("Registry Modified: " + key);
        if (key.toLowerCase().startsWith("appdata/cinema/triggers")) {
            this.loadTriggerConfig();
        } else if (key.toLowerCase().startsWith("appdata/cinema/schedule")) {
            this.loadSchedulesConfig();
        }
    }

    private void loadTriggerConfig() {
        int i;
        FileLogger.info("Load Trigger Config");
        for (i = 0; i < UnitConfig.getInputCount(); ++i) {
            String regInputTriggerMacro = "AppData/Cinema/Triggers/Input" + (i + 1) + "Macro";
            Config.INPUT_TRIGGER_MACROS[i] = RegistryUtils.getRegistryKey(regInputTriggerMacro, "none");
        }
        for (i = 0; i < UnitConfig.getInputCount(); ++i) {
            String regTriggerDelayTime = "AppData/Cinema/Triggers/Input" + (i + 1) + "DelayTime";
            Config.INPUT_TRIGGER_DELAY_TIMES[i] = RegistryUtils.getRegistryKey(regTriggerDelayTime, 0);
        }
        for (i = 0; i < UnitConfig.getOutputCount(); ++i) {
            String regOutputTriggerMacro = "AppData/Cinema/Triggers/Output" + (i + 1) + "Macro";
            Config.OUTPUT_TRIGGER_MACROS[i] = RegistryUtils.getRegistryKey(regOutputTriggerMacro, "none");
        }
    }
}

