/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;

public class ClientHandler {
    private final byte[] _inBuffer = new byte[1024];
    private final InputStream _in;
    private boolean _isSocket;
    private int _inBufferPos = 0;
    private byte[] _terminationBytes = new byte[0];

    public ClientHandler(InputStream in, boolean isSocket) {
        this._in = in;
        this._isSocket = isSocket;
    }

    public void setTerminationBytes(byte[] terminationBytes) {
        this._terminationBytes = terminationBytes;
    }

    public String getMessage() throws Throwable {
        try {
            while (true) {
                if (this._inBufferPos > 0) {
                    int terminationIndex = this.getTerminationIndex();
                    System.out.println("termination found at " + terminationIndex);
                    if (terminationIndex >= 0) {
                        String message = new String(this._inBuffer, 0, terminationIndex);
                        int bytesConsumed = terminationIndex + this._terminationBytes.length;
                        ArrayUtils.arraycopy((Object)this._inBuffer, (int)bytesConsumed, (Object)this._inBuffer, (int)0, (int)(this._inBufferPos - bytesConsumed));
                        this._inBufferPos -= bytesConsumed;
                        return message;
                    }
                }
                if (!this._isSocket) {
                    this.waitForNewData();
                }
                int bytesRead = this._in.read(this._inBuffer, this._inBufferPos, this._inBuffer.length - this._inBufferPos);
                this._inBufferPos += bytesRead;
                System.out.println(bytesRead + " bytesRead");
            }
        }
        catch (InterruptedException bytesRead) {
        }
        catch (IOException ex) {
            if (this._inBufferPos != 0) {
                String hexDump = HexUtils.hexDump(this._inBuffer, 0, this._inBufferPos);
                FileLogger.warn("/cinema_debug.log", "bytes received: " + hexDump + "\r\n");
                String message = new String(this._inBuffer, 0, this._inBufferPos);
                ArrayUtils.arraycopy((Object)this._inBuffer, (int)0, (Object)this._inBuffer, (int)0, (int)this._inBufferPos);
                this._inBufferPos = 0;
                return message;
            }
            return null;
        }
        return "";
    }

    private boolean isDataAvailable() throws IOException {
        return this._in.available() > 0;
    }

    private void waitForNewData() throws IOException, InterruptedException {
        while (!this.isDataAvailable()) {
            Thread.sleep(250L);
        }
    }

    private int getTerminationIndex() {
        for (int i = 0; i < this._inBufferPos; ++i) {
            int j;
            if (this._inBuffer[i] != this._terminationBytes[0]) continue;
            for (j = 1; j < this._terminationBytes.length && i + j < this._inBufferPos && this._inBuffer[i + j] == this._terminationBytes[j]; ++j) {
            }
            if (j != this._terminationBytes.length) continue;
            return i;
        }
        return -1;
    }
}

