/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class DolbyCP650Serial
extends TheatreSerialDevice {
    private static final byte[] TERMINATION_BYTES = "\r\n".getBytes();
    private static final String FADER_LEVEL = "fader_level=";
    private static final String FADER_SETTING = "fader_setting=";
    private static final String FORMAT_BUTTON = "format_button=";
    private static final String MUTE = "mute=";

    public DolbyCP650Serial(String name) {
        super(name);
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        block22: {
            System.out.println("CP650 macro: " + macroName);
            if (macroName.toLowerCase().startsWith("fader level")) {
                try {
                    macroName = FADER_LEVEL + macroName.substring(12);
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Fader Level");
                        break block22;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
            } else if (macroName.toLowerCase().startsWith("fader setting")) {
                try {
                    macroName = FADER_SETTING + macroName.substring(14);
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Adjusting Fader Setting");
                        break block22;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader Setting");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader Setting");
                }
            } else if (macroName.toLowerCase().startsWith("format button")) {
                try {
                    macroName = FORMAT_BUTTON + macroName.substring(14);
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Format Button");
                        break block22;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting  Format Button");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting  Format Button");
                }
            } else if (macroName.toLowerCase().startsWith("set mute")) {
                try {
                    macroName = MUTE + macroName.substring(9);
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Mute");
                        break block22;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
            } else if (macroName.toLowerCase().startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (data == null) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                this.send(dataBytes);
            }
        }
        return true;
    }

    public boolean send(byte[] bytes) {
        if (this.serial == null && !this.ensureConnection()) {
            return false;
        }
        try {
            if (this.out != null) {
                this.bos.reset();
                this.bos.write(bytes);
                this.bos.write(TERMINATION_BYTES);
                this.out.write(this.bos.toByteArray());
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            return false;
        }
        return true;
    }
}

