/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;
import java.util.Date;

public class QSCDCP300Ethernet
extends TheatreEthernetDevice {
    private static byte[] ZEROS = new byte[]{0, 0, 0, 0, 0};
    private static final String ACTIVE_AUDIO_PRESET = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x00290000\" M=\"0\" S=\"{VALUE}\"/></SET_S>";
    private static final String ACTIVE_CONTROL_PRESET = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x002E0000\" M=\"0\" S=\"{VALUE}\"/></SET_S>";
    private static final String MASTER_GAIN = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001B0000\" M=\"0\" F=\"{VALUE}\"/></SET_S>";
    private static final String MASTER_MUTE = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001C0000\" M=\"0\" B=\"{VALUE}\"/></SET_S>";
    private static final String MASTER_AMP_POWER_ON = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x001D0000\" M=\"0\" B=\"true\"/></SET_S>";
    private static final String MASTER_AMP_POWER_STANDBY = "<?xml version=\"1.0\"?><!--{-LEN-}--><SET_S RT=\"C00\" ID=\"0\" L1PW=\"qsc\"><ESS O=\"0x002F0000\" M=\"0\" B=\"true\"/></SET_S>";

    public QSCDCP300Ethernet(String name) {
        super(name);
        this.port = "4446";
    }

    @Override
    public boolean login() {
        return true;
    }

    private String replace(String original, String search, String newString) {
        String s = null;
        int pos = original.indexOf(search);
        if (pos >= 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(original.substring(0, pos));
            sb.append(newString);
            sb.append(original.substring(pos + search.length()));
            s = sb.toString();
        } else {
            s = original;
        }
        return s;
    }

    private String getLengthString(int length) {
        String lengthString = "0000000" + String.valueOf(length);
        lengthString = lengthString.substring(lengthString.length() - 7, lengthString.length());
        return lengthString;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        System.out.println(new Date().toString() + "QSCDCP300 macro: " + macroName);
        if (macroName.toLowerCase().startsWith("active audio preset")) {
            try {
                macroName = this.replace(ACTIVE_AUDIO_PRESET, "{VALUE}", macroName.substring(20));
                macroName = this.replace(macroName, "{-LEN-}", this.getLengthString(macroName.length()));
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Active audio preset Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Active audio preset");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Active audio preset");
            }
        } else if (macroName.toLowerCase().startsWith("active control preset")) {
            try {
                macroName = this.replace(ACTIVE_CONTROL_PRESET, "{VALUE}", macroName.substring(22));
                macroName = this.replace(macroName, "{-LEN-}", this.getLengthString(macroName.length()));
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Active control preset Adjusted");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Active control preset");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Active control preset");
            }
        } else if (macroName.toLowerCase().startsWith("master gain")) {
            try {
                macroName = this.replace(MASTER_GAIN, "{VALUE}", macroName.substring(12));
                macroName = this.replace(macroName, "{-LEN-}", this.getLengthString(macroName.length()));
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master gain Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master gain");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master gain");
            }
        } else if (macroName.toLowerCase().startsWith("master mute")) {
            try {
                macroName = this.replace(MASTER_MUTE, "{VALUE}", macroName.substring(12));
                macroName = this.replace(macroName, "{-LEN-}", this.getLengthString(macroName.length()));
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master mute Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master mute");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master mute");
            }
        } else if (macroName.toLowerCase().startsWith("master amp power on")) {
            try {
                macroName = MASTER_AMP_POWER_ON;
                macroName = this.replace(macroName, "{-LEN-}", this.getLengthString(macroName.length()));
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master amp power on Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power on");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power on");
            }
        } else if (macroName.toLowerCase().startsWith("master amp power standby")) {
            try {
                macroName = MASTER_AMP_POWER_STANDBY;
                macroName = this.replace(macroName, "{-LEN-}", this.getLengthString(macroName.length()));
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Master amp power standby Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power standby");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Master amp power standby");
            }
        } else if (macroName.toLowerCase().startsWith("send")) {
            String send = macroName.substring(5);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            return this.send(dataBytes);
        }
        return false;
    }

    public synchronized boolean send(byte[] dataBytes) {
        if (this.ensureConnection()) {
            try {
                if (dataBytes == null) {
                    System.out.println(this.name + " databytes null");
                }
                this.bos.reset();
                this.bos.write(dataBytes);
                this.out.write(this.bos.toByteArray());
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                try {
                    this.disconnect();
                    if (!this.ensureConnection()) {
                        this.disconnect();
                        return false;
                    }
                    this.out.write(this.bos.toByteArray());
                }
                catch (IOException ex2) {
                    FileLogger.error(ex2);
                    this.disconnect();
                    return false;
                }
            }
        } else {
            System.out.println("Could not connect");
            return false;
        }
        return true;
    }
}

