/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.client.CinemaServerClient;
import com.integpg.cinema.client.CinemaServerClientHandler;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class CinemaServerClientTcpServer
implements Runnable {
    private ServerSocket _svrSocket;
    private int m_port;
    private Thread theServer;
    private boolean bServerRun = true;
    private CinemaServerClient m_parent;
    private Vector clients = new Vector();

    public CinemaServerClientTcpServer(CinemaServerClient parent, int port) {
        this.m_parent = parent;
        this.m_port = port;
    }

    public int getPort() {
        return this._svrSocket.getLocalPort();
    }

    public void start() {
        FileLogger.info("Listen on port: " + this.m_port);
        try {
            this._svrSocket = new ServerSocket(this.m_port);
            this.theServer = new Thread((Runnable)this, "Cinema Server Client Server");
            this.theServer.start();
        }
        catch (Exception ex) {
            FileLogger.error(ex);
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this._svrSocket.close();
        try {
            this.theServer.interrupt();
            this.theServer.join();
        }
        catch (InterruptedException ex) {
            FileLogger.error(ex);
        }
    }

    @Override
    public void run() {
        try {
            while (this.bServerRun) {
                try {
                    System.out.println("Listening for clients on port " + this.m_port + ".");
                    Socket socket = this._svrSocket.accept();
                    Logger.getLogger("test").info(String.format("%s:%d connected", socket.getInetAddress().getHostAddress(), socket.getPort()));
                    CinemaServerClientHandler handler = new CinemaServerClientHandler(this.m_parent, socket.getInputStream(), socket.getOutputStream(), socket);
                    this.clients.addElement(handler);
                    ThreadPool.execute(handler);
                }
                catch (IOException ex) {
                    FileLogger.error(ex);
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    FileLogger.error(ex);
                }
            }
        }
        catch (Exception ex) {
            if (this.bServerRun) {
                FileLogger.error(ex);
            }
            this.bServerRun = false;
        }
        try {
            this._svrSocket.close();
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
        this._svrSocket = null;
    }

    public void remove(CinemaServerClientHandler clientHandler) {
        if (!this.clients.removeElement(clientHandler)) {
            System.out.println("Unable to remove client");
        }
    }

    void send(String message) throws IOException {
        Enumeration elements = this.clients.elements();
        while (elements.hasMoreElements()) {
            CinemaServerClientHandler handler = (CinemaServerClientHandler)elements.nextElement();
            handler.send(message);
        }
    }
}

