/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class DolbyCP750Serial
extends TheatreSerialDevice {
    private static final String FADER_LEVEL = "cp750.sys.fader ";
    private static final String INPUT_MODE = "cp750.sys.input_mode ";
    private static final String MUTE = "cp750.sys.mute ";

    public DolbyCP750Serial(String name) {
        super(name);
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        block17: {
            System.out.println("CP750 macro: " + macroName);
            if (macroName.toLowerCase().startsWith("fader level")) {
                try {
                    macroName = FADER_LEVEL + macroName.substring(12) + "\r";
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Fader Level");
                        break block17;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
            } else if (macroName.toLowerCase().startsWith("input mode")) {
                try {
                    macroName = INPUT_MODE + macroName.substring(11) + "\r";
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Input Mode");
                        break block17;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input Mode");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input Mode");
                }
            } else if (macroName.toLowerCase().startsWith("set mute")) {
                try {
                    macroName = MUTE + macroName.substring(9) + "\r";
                    if (this.send(macroName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Mute");
                        break block17;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
            } else if (macroName.toLowerCase().startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (data == null) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                this.send(dataBytes);
            }
        }
        return true;
    }

    public boolean send(byte[] bytes) {
        if (this.serial == null && !this.ensureConnection()) {
            return false;
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            return false;
        }
        return true;
    }
}

