/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalDeviceOrder;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class Type28
extends ExternalModule {
    private double _tempC;
    private double _tempF;

    public static Type28[] getDeviceArray() {
        return ExternalDeviceOrder.getType28Array();
    }

    public static Type28 getByIndex(int index) {
        Type28[] deviceArray = Type28.getDeviceArray();
        return deviceArray[index];
    }

    Type28(long address) {
        super(address, -1, "Type28");
    }

    Type28(long address, int index) {
        super(address, index, "Type28");
    }

    @Override
    public long getMinReadInterval() {
        return 1000L;
    }

    public double getTempC() {
        return this._tempC;
    }

    public double getTempF() {
        return this._tempF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws Throwable {
        try {
            this._hasChanged = false;
            SensorPort sensorPort = SENSOR_PORT;
            synchronized (sensorPort) {
                this._dataBlock = SensorPort.readDeviceBlock((long)this.Address);
                if (null == this._dataBlock || this._dataBlock.length != 8) {
                    throw new IOException("Unable to read " + this.AddressString);
                }
            }
            this.LastReadTime = System.currentTimeMillis();
            if (this.checkForChange()) {
                long longBits = ArrayUtils.getLong((byte[])this._dataBlock, (int)0);
                this._tempC = Double.longBitsToDouble(longBits);
                this._tempF = this._tempC * 9.0 / 5.0 + 32.0;
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading temperature module").initCause(ex);
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void printValues() {
    }

    public static Object get(int channel, String fieldName) {
        try {
            int index = channel - 1;
            Type28 device = Type28.getByIndex(index);
            if (null != device) {
                device.read();
                return device.get(fieldName);
            }
            throw new RuntimeException("Ten Volt Module not present for index " + index);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error getting value for Type28." + fieldName, ex);
        }
    }

    @Override
    public Object get(String fieldName) {
        if ("tempf".equalsIgnoreCase(fieldName)) {
            return this.getTempF();
        }
        if ("tempc".equalsIgnoreCase(fieldName)) {
            return this.getTempC();
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }

    public String toString() {
        return String.format("   %s: %.3f C, %.3f F", this.AddressString, this.getTempC(), this.getTempF());
    }
}

