/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.firealarm;

import com.integpg.cinema.CinemaIO;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.Monitor.IOStateListener;
import com.integpg.cinema.client.PreshowClientHandler;
import com.integpg.cinema.firealarm.FireAlarmListener;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.util.EventObject;
import java.util.TimerTask;
import java.util.Vector;

public class FireAlarm
extends TimerTask
implements IOStateListener,
MacroRequestListener {
    public static int m_fireAlarm = 0;
    private Thread thd = null;
    private int m_fireAlarmInputState = 0;
    private long m_fireAlarmClearTime = 0L;
    private Vector _listeners = new Vector();

    public FireAlarm() {
        this.m_fireAlarmInputState = JANOS.getInputStates() >> Config.FIRE_ALARM_INPUT - 1 & 1;
    }

    public int getFireAlarmStatus() {
        return m_fireAlarm;
    }

    private void fireAlarmEvent() {
        CinemaMain.INSTANCE.sendTrap("1.3.6.1.4.1.31976.2.0.5", Config.FIRE_ALARM_ACTIVE_TEXT);
        CinemaMain.INSTANCE.setSnmpOidValue("1.3.6.1.4.1.31976.2.2.1.0", 1, Config.COMMUNITY_NAME);
        FileLogger.info(Config.FIRE_ALARM_ACTIVE_TEXT);
        CinemaMain.MacroFile.runMacros(this, Config.FIRE_ALARM_MACRO);
        if (Config.FIRE_ALARM_INPUT != Config.FIRE_ALARM_RELEASE_INPUT && Config.FIRE_ALARM_INPUT != -1 && Config.FIRE_ALARM_RELEASE_INPUT != -1) {
            if (this.thd != null) {
                this.thd.interrupt();
                this.thd = null;
            }
            CinemaMain.TIMER.schedule((TimerTask)this, 15000L);
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((FireAlarmListener)this._listeners.elementAt(i)).fireAlarmActive(new EventObject(this));
        }
    }

    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputStateMask, long outputStateMask) {
        System.out.println(io + " " + channel + ":" + state + " " + Config.FIRE_ALARM_INPUT + " " + Config.FIRE_ALARM_RELEASE_INPUT);
        if (io == 0 && channel == Config.FIRE_ALARM_INPUT && m_fireAlarm == 0) {
            System.out.println(state + " " + m_fireAlarm + " " + this.m_fireAlarmInputState);
            if (JANOS.uptimeMillis() - 10000L > this.m_fireAlarmClearTime && state == 1 && m_fireAlarm == 0 && this.m_fireAlarmInputState == 0) {
                m_fireAlarm = 1;
                this.fireAlarmEvent();
            }
            this.m_fireAlarmInputState = state;
        } else if (io == 0 && channel == Config.FIRE_ALARM_RELEASE_INPUT && m_fireAlarm == 1) {
            System.out.println(state + " " + m_fireAlarm + " " + this.m_fireAlarmInputState);
            if (Config.FIRE_ALARM_INPUT == Config.FIRE_ALARM_RELEASE_INPUT && state == 0 || Config.FIRE_ALARM_INPUT != Config.FIRE_ALARM_RELEASE_INPUT && state == 1) {
                System.out.println("Clear Fire Alarm");
                this.cancel();
                this.m_fireAlarmClearTime = JANOS.uptimeMillis();
                JANOS.setInputConditioning((int)(Config.FIRE_ALARM_INPUT - 1), (int)0);
                this.m_fireAlarmInputState = 0;
                m_fireAlarm = 0;
                if (this.thd != null) {
                    this.thd.interrupt();
                }
                System.out.println(Config.FIRE_ALARM_CLEAR_TEXT);
                CinemaMain.INSTANCE.sendTrap("1.3.6.1.4.1.31976.2.0.5", Config.FIRE_ALARM_CLEAR_TEXT);
                CinemaMain.INSTANCE.setSnmpOidValue("1.3.6.1.4.1.31976.2.2.1.0", 0, Config.COMMUNITY_NAME);
                FileLogger.info(Config.FIRE_ALARM_CLEAR_TEXT);
                if (CinemaIO.getPreshowLock() == 1) {
                    CinemaMain.MacroFile.runMacro(this, Config.FIRE_ALARM_MOVIE_CLEAR_MACRO);
                } else {
                    CinemaMain.MacroFile.runMacro(this, Config.FIRE_ALARM_PRESHOW_CLEAR_MACRO);
                }
                for (int i = 0; i < this._listeners.size(); ++i) {
                    ((FireAlarmListener)this._listeners.elementAt(i)).fireAlarmClear(new EventObject(this));
                }
            }
        }
    }

    @Override
    public void run() {
        if (m_fireAlarm == 1) {
            System.out.println("Do fire alarm inversion");
            boolean inversion = JANOS.getRegistryBoolean((String)("IO/Inputs/din" + Config.FIRE_ALARM_INPUT + "/Inversion"), (boolean)false);
            JANOS.setRegistryString((String)("IO/Inputs/din" + Config.FIRE_ALARM_INPUT + "/Inversion"), (String)String.valueOf(!inversion));
            CinemaMain.TIMER.schedule((TimerTask)this, 15000L);
        } else {
            System.out.println("Fire alarm must have been cleared");
        }
    }

    public void addListener(PreshowClientHandler listener) {
        this._listeners.addElement(listener);
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        FileLogger.info(macroResult.getReason());
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }
}

