/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class Jsd100Ethernet
extends TheatreEthernetDevice {
    private static final String FADER = "jsd100.sys.fader\t";
    private static final String FADER_RELATIVE = "jsd100.sys.fader_rel\t";
    private static final String INPUT_MODE = "jsd100.sys.input_mode\t";
    private static final String MUTE = "jsd100.sys.mute\t";

    public Jsd100Ethernet(String name) {
        super(name);
        this.port = "5000";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        System.out.println("Jsd100 macro: " + macroName);
        if (macroName.toLowerCase().startsWith("set fader")) {
            try {
                macroName = FADER + macroName.substring(10) + "\r";
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Fader Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader");
            }
        } else if (macroName.toLowerCase().startsWith("adjust fader")) {
            try {
                macroName = FADER_RELATIVE + macroName.substring(13) + "\r";
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Fader Adjusted");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader");
            }
        } else if (macroName.toLowerCase().startsWith("set input")) {
            try {
                macroName = INPUT_MODE + macroName.substring(10) + "\r";
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Input Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input");
            }
        } else if (macroName.toLowerCase().startsWith("set mute")) {
            try {
                macroName = MUTE + macroName.substring(9) + "\r";
                if (this.send(macroName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Mute Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
            }
        } else if (macroName.toLowerCase().startsWith("send")) {
            String send = macroName.substring(5);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            return this.send(dataBytes);
        }
        return false;
    }

    public synchronized boolean send(byte[] dataBytes) {
        if (this.ensureConnection()) {
            try {
                if (dataBytes == null) {
                    System.out.println(this.name + " databytes null");
                }
                this.bos.reset();
                this.bos.write(dataBytes);
                this.out.write(this.bos.toByteArray());
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                try {
                    this.disconnect();
                    if (!this.ensureConnection()) {
                        this.disconnect();
                        return false;
                    }
                    this.out.write(this.bos.toByteArray());
                }
                catch (IOException ex2) {
                    FileLogger.error(ex2);
                    this.disconnect();
                    return false;
                }
            }
        } else {
            System.out.println("Could not connect");
            return false;
        }
        return true;
    }
}

