/*
 * Decompiled with CFR 0.152.
 */
package com.barco.pulse.json;

import com.barco.pulse.json.JsonStream;
import com.barco.pulse.json.JsonValidator;
import java.util.Json;

public class JsonStreamTest {
    public static void doTest() {
        try {
            String fullJson = "{\n \"jsonrpc\": \"2.0\",\n \"id\": 1,\n \"result\": true\n}";
            long start = System.currentTimeMillis();
            JsonValidator jsonValidator = new JsonValidator(fullJson);
            System.out.println(String.format("%s is valid: %s\r\n", jsonValidator.getJsonString(), String.valueOf(jsonValidator.isJsonPresent())));
            if (jsonValidator.isJsonPresent()) {
                System.out.println(String.format("Json object: %s", jsonValidator.getJsonObject().toString()));
            }
            long elapsed = System.currentTimeMillis() - start;
            System.out.println(String.format("elapsed: %lld", elapsed));
            String partialJson = "{\n \"jsonrpc\": \"2.0\",\n \"id\": 1,\n \"re";
            start = System.currentTimeMillis();
            jsonValidator = new JsonValidator(partialJson);
            System.out.println(String.format("%s is valid: %s, ending at: %d\r\n", jsonValidator.getJsonString(), String.valueOf(jsonValidator.isJsonPresent()), jsonValidator.getEndPos()));
            if (jsonValidator.isJsonPresent()) {
                System.out.println(String.format("Json object: %s", jsonValidator.getJsonObject().toString()));
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println(String.format("elapsed: %lld", elapsed));
            String complexJson = "{\n \"jsonrpc\": \"2.0\",\n \"id\": 1,\n \"params\": {\n   \"jsonrpc\": \"2.0\",\n   \"id\": 1,\n   \"result\": true\n  } \"result\": true\n}";
            start = System.currentTimeMillis();
            jsonValidator = new JsonValidator(complexJson);
            System.out.println(String.format("%s is valid: %s, ending at: %d\r\n", jsonValidator.getJsonString(), String.valueOf(jsonValidator.isJsonPresent()), jsonValidator.getEndPos()));
            if (jsonValidator.isJsonPresent()) {
                System.out.println(String.format("Json object: %s", jsonValidator.getJsonObject().toString()));
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println(String.format("elapsed: %lld", elapsed));
            String multiJson = "{\n \"jsonrpc\": \"2.0\",\n \"id\": 1,\n \"params\": {\n   \"jsonrpc\": \"2.0\",\n   \"id\": 1,\n   \"result\": true\n  } \"result\": true\n}{\n \"jsonrpc\": \"2.0\",\n \"id\": 1,\n \"params\": {\n   \"jsonrpc\": \"2.0\",\n   \"id\": 1,\n   \"result\": true\n  } \"result\": true\n}";
            start = System.currentTimeMillis();
            jsonValidator = new JsonValidator(multiJson);
            System.out.println(String.format("%s is valid: %s, ending at: %d\r\n", jsonValidator.getJsonString(), String.valueOf(jsonValidator.isJsonPresent()), jsonValidator.getEndPos()));
            if (jsonValidator.isJsonPresent()) {
                System.out.println(String.format("Json object: %s", jsonValidator.getJsonObject().toString()));
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println(String.format("elapsed: %lld", elapsed));
            String testJson = "{\n \"jsonrpc\": \"2.0\\\"}}\",\n \"id\": 1,\n \"result\": true\n}";
            start = System.currentTimeMillis();
            jsonValidator = new JsonValidator(testJson);
            System.out.println(String.format("%s is valid: %s, ending at: %d\r\n", jsonValidator.getJsonString(), String.valueOf(jsonValidator.isJsonPresent()), jsonValidator.getEndPos()));
            if (jsonValidator.isJsonPresent()) {
                System.out.println(String.format("Json object: %s", jsonValidator.getJsonObject().toString()));
            }
            elapsed = System.currentTimeMillis() - start;
            System.out.println(String.format("elapsed: %lld", elapsed));
            System.out.println("");
            System.out.println("");
            JsonStream jsonStream = new JsonStream();
            jsonStream.append(fullJson);
            jsonStream.append('\n');
            jsonStream.append(testJson);
            jsonStream.append('\n');
            jsonStream.append(complexJson);
            jsonStream.append('\n');
            jsonStream.append(fullJson);
            jsonStream.append('\n');
            jsonStream.append(partialJson);
            jsonStream.append('\n');
            while (0 < jsonStream.length()) {
                System.out.println(String.format("get next JSON object from %s", jsonStream.toString()));
                start = System.currentTimeMillis();
                int startLength = jsonStream.length();
                Json json = jsonStream.getNextJson();
                if (null != json) {
                    System.out.println("json: " + json);
                }
                elapsed = System.currentTimeMillis() - start;
                System.out.println(String.format("elapsed: %lld", elapsed));
                if (jsonStream.length() != startLength) continue;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

