/*
 * Decompiled with CFR 0.152.
 */
package com.barco.pulse.json;

import java.util.Json;

public class JsonValidator {
    private final String _jsonString;
    private int _pos = 0;
    private boolean _isValid = false;
    private boolean _processed = false;
    private boolean _incomplete = false;

    public JsonValidator(String jsonString) {
        this._jsonString = jsonString;
    }

    public String getJsonString() {
        return this._jsonString;
    }

    public int getEndPos() {
        return this._pos;
    }

    public Json getJsonObject() {
        Json json = null;
        if (this._isValid) {
            json = new Json(this._jsonString.substring(0, this._pos));
        }
        return json;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isJsonPresent() {
        block10: {
            if (this._processed) break block10;
            this._processed = true;
            int openBraceCount = 0;
            boolean isInString = false;
            int stringLength = this._jsonString.length();
            while (this._pos < stringLength) {
                block11: {
                    char c = this._jsonString.charAt(this._pos);
                    switch (c) {
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block11;
                        }
                        case '{': {
                            if (isInString) break;
                            ++openBraceCount;
                            break;
                        }
                        case '}': {
                            if (isInString) break;
                            --openBraceCount;
                            break;
                        }
                        case '\"': {
                            isInString = !isInString;
                            break;
                        }
                        case '\\': {
                            if (stringLength <= this._pos + 1) break;
                            ++this._pos;
                            c = this._jsonString.charAt(this._pos);
                        }
                    }
                    if (0 == openBraceCount) {
                        this._isValid = true;
                        break;
                    }
                }
                ++this._pos;
            }
            if (!this._isValid && 0 < this._pos) {
                this._incomplete = true;
            }
        }
        return this._isValid;
    }

    public boolean isIncomplete() {
        return this._incomplete;
    }
}

