/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.MinimumVersion;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import com.integpg.system.ConsoleProcess;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Rebooter {
    public static void sendReboot() throws SocketException, UnknownHostException, IOException {
        Rebooter.sendReboot(false);
    }

    public static void sendRebootAndClearHeap() throws SocketException, UnknownHostException, IOException {
        Rebooter.sendReboot(true);
    }

    public static void sendReboot(boolean clearHeap) throws SocketException, UnknownHostException, IOException {
        try {
            if (MinimumVersion.atLeast("1.6.3")) {
                FileLogger.info("Using the console to reboot");
                Thread.sleep(5000L);
                String rebootCommand = String.format("reboot -%sf", clearHeap ? "a" : "");
                FileLogger.info(rebootCommand);
                ConsoleProcess consoleProcess = new ConsoleProcess(rebootCommand);
                consoleProcess.waitPrompt();
            } else {
                FileLogger.info("Using beacon to reboot");
                byte[] sendBytes = new byte[14];
                ArrayUtils.setShort((byte[])sendBytes, (int)0, (short)14);
                ArrayUtils.setInt((byte[])sendBytes, (int)2, (int)JANOS.getSerialNumber());
                ArrayUtils.setShort((byte[])sendBytes, (int)6, (short)6);
                ArrayUtils.arraycopy((Object)"REBOOT".getBytes(), (int)0, (Object)sendBytes, (int)8, (int)6);
                DatagramSocket clientSocket = new DatagramSocket();
                DatagramPacket sendPacket = new DatagramPacket(sendBytes, sendBytes.length, InetAddress.getByName("127.0.0.1"), 4444);
                clientSocket.send(sendPacket);
                clientSocket.close();
                System.out.println("Reboot sent");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

