/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.devices.Barco;
import com.integpg.cinema.devices.BarcoSeries4;
import com.integpg.cinema.devices.Christie;
import com.integpg.cinema.devices.DolbyCP650Ethernet;
import com.integpg.cinema.devices.DolbyCP650Serial;
import com.integpg.cinema.devices.DolbyCP750Ethernet;
import com.integpg.cinema.devices.DolbyCP750Serial;
import com.integpg.cinema.devices.HttpRequest;
import com.integpg.cinema.devices.Jsd100Ethernet;
import com.integpg.cinema.devices.NEC;
import com.integpg.cinema.devices.NEC_VT700;
import com.integpg.cinema.devices.QSCDCP300Ethernet;
import com.integpg.cinema.devices.RawEthernet;
import com.integpg.cinema.devices.RawSerial;
import com.integpg.cinema.devices.RawUdp;
import com.integpg.cinema.devices.TheatreDevice;

class DeviceFactory {
    DeviceFactory() {
    }

    public static TheatreDevice getDevice(String deviceName, String deviceType, String portString) {
        System.out.println("deviceName = " + deviceName);
        System.out.println("deviceType = " + deviceType);
        System.out.println("portString = " + portString);
        if (deviceType.equals("BARCO")) {
            if ("43731".equals(portString)) {
                return new BarcoSeries4(deviceName);
            }
            return new Barco(deviceName);
        }
        if (deviceType.equals("CHRISTIE")) {
            return new Christie(deviceName);
        }
        if (deviceType.equals("NEC")) {
            return new NEC(deviceName);
        }
        if (deviceType.equals("NEC SERIES 2")) {
            return new NEC(deviceName);
        }
        if (deviceType.equalsIgnoreCase("NEC VT700 SERIAL")) {
            return new NEC_VT700(deviceName);
        }
        if (deviceType.equalsIgnoreCase("USL JSD100 ETHERNET")) {
            return new Jsd100Ethernet(deviceName);
        }
        if (deviceType.equalsIgnoreCase("DOLBY CP650 SERIAL")) {
            return new DolbyCP650Serial(deviceName);
        }
        if (deviceType.equalsIgnoreCase("DOLBY CP650 ETHERNET")) {
            return new DolbyCP650Ethernet(deviceName);
        }
        if (deviceType.equalsIgnoreCase("DOLBY CP750 SERIAL")) {
            return new DolbyCP750Serial(deviceName);
        }
        if (deviceType.equalsIgnoreCase("DOLBY CP750 ETHERNET")) {
            return new DolbyCP750Ethernet(deviceName);
        }
        if (deviceType.equalsIgnoreCase("QSC DCP300 ETHERNET")) {
            return new QSCDCP300Ethernet(deviceName);
        }
        if (deviceType.equals("RAW SERIAL")) {
            return new RawSerial(deviceName);
        }
        if (deviceType.equals("RAW ETHERNET")) {
            return new RawEthernet(deviceName);
        }
        if (deviceType.equals("RAW UDP")) {
            return new RawUdp(deviceName);
        }
        if (deviceType.equals("HTTP Request")) {
            return new HttpRequest(deviceName);
        }
        return null;
    }
}

