/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class TheatreDevice {
    protected String _host;
    protected String port;
    protected String username;
    protected String password;
    protected int baud;
    protected int dataBits;
    protected int parity;
    protected int stopBits;
    protected int flowControl;
    protected String terminationString;
    protected String convertedTermString;
    protected InputStream in;
    protected OutputStream out;
    protected String name;
    protected boolean HAS_FAILED = false;
    protected ByteArrayOutputStream bos = new ByteArrayOutputStream();
    protected static Hashtable m_projectors = new Hashtable();

    public TheatreDevice() {
    }

    public TheatreDevice(String name) {
        this.name = name.toUpperCase();
    }

    public abstract boolean macroExecute(String var1);

    public String getName() {
        return this.name;
    }

    public static Hashtable getProjectors() {
        return m_projectors;
    }

    protected String convertHexToString(String hexString) {
        if ((hexString = hexString.toLowerCase()).startsWith("hex ")) {
            boolean oldStyle = true;
            for (int i = 6; i < hexString.length(); i += 4) {
                if (!hexString.substring(i, i + 1).equals("h")) {
                    oldStyle = false;
                    break;
                }
                if (i + 1 >= hexString.length() || hexString.substring(i + 1, i + 2).equals(" ")) continue;
                oldStyle = false;
                break;
            }
            StringBuffer sb = new StringBuffer(64);
            if (oldStyle) {
                for (int i = 4; i < hexString.length(); i += 4) {
                    int value = Integer.parseInt(hexString.substring(i, i + 2), 16);
                    sb.append((char)value);
                }
            } else {
                try {
                    for (int i = 4; i < hexString.length(); i += 2) {
                        int value = Integer.parseInt(hexString.substring(i, i + 2), 16);
                        sb.append((char)value);
                    }
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, hexString + " is not a valid hex string");
                    return null;
                }
            }
            return sb.toString();
        }
        return null;
    }

    protected static byte[] unescapeString(String string) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (string.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\t';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                        break;
                    }
                    case 'x': {
                        String s = string.substring(i + 1, i + 3);
                        newTermString = newTermString + (char)Integer.parseInt(s, 16);
                        i += 2;
                    }
                }
            } else {
                newTermString = newTermString + string.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString.getBytes();
    }

    public void setHost(String host) {
        System.out.println(this.name + " host = " + host);
        if ("127.0.0.1".equals(host)) {
            host = JANOS.getRegistryString((String)"ipconfig/ipaddress", (String)"");
            System.out.println(this.name + " host = " + host);
        }
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(String port) {
        System.out.println("PORT=" + port);
        this.port = port;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    public int getBaud() {
        return this.baud;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public void setParity(String parity) {
        if (parity.equals("NONE")) {
            this.parity = 0;
        } else if (parity.equals("EVEN")) {
            this.parity = 2;
        } else if (parity.equals("ODD")) {
            this.parity = 1;
        }
    }

    public void setStopBits(double stopBits) {
        this.stopBits = (int)stopBits;
    }

    public void setFlowControl(String flowControl) {
        if (flowControl.equals("NONE")) {
            this.flowControl = 0;
        }
    }

    public void setTerminationString(String terminationString) {
        this.terminationString = terminationString;
        this.convertedTermString = new String(this.getTerminationBytes(this.terminationString));
    }

    private byte[] getTerminationBytes(String terminationString) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < terminationString.length(); ++i) {
            if (terminationString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (terminationString.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case '\"': {
                        newTermString = newTermString + '\"';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                    }
                }
            } else {
                newTermString = newTermString + terminationString.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString.getBytes();
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean connect(String host, String port) {
        return false;
    }

    public void disconnect() {
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        finally {
            super.finalize();
        }
    }
}

