/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.InterProcess.InterProcessArgument;
import com.integpg.cinema.InterProcess.InterProcessEvent;
import com.integpg.cinema.InterprocessMacroResponse;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import com.integpg.system.SystemMsg;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.EventObject;
import java.util.Hashtable;

public class ProtocolCommandMonitor
implements MessagePumpListener,
InterProcessEvent {
    private static Hashtable eventHooks = new Hashtable();

    public void setLocalHook(String command, InterProcessEvent ipce) throws Exception {
        if (!eventHooks.contains(command)) {
            eventHooks.put(command, ipce);
        }
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (112 == systemMsg.type) {
            try {
                FileLogger.info("MessagePump", "Protocol Command Message: " + HexUtils.hexDump(systemMsg.msg));
                this.ProcessSystemMsg(systemMsg);
            }
            catch (Exception ex) {
                FileLogger.error(ex);
            }
        }
    }

    private void ProcessSystemMsg(SystemMsg msg) throws Exception {
        try {
            InterProcessArgument[] arguments = null;
            byte[] source = new byte[6];
            ArrayUtils.arraycopy((Object)msg.msg, (int)0, (Object)source, (int)0, (int)6);
            int port = ArrayUtils.getShort((byte[])source, (int)4) & 0xFFFF;
            System.out.println("Message from " + source[0] + '.' + source[1] + '.' + source[2] + '.' + source[3] + ":" + port);
            byte commandNameLength = msg.msg[6];
            String commandName = new String(msg.msg, 7, (int)commandNameLength);
            if ("macro".equalsIgnoreCase(commandName)) {
                byte type = msg.msg[7 + commandNameLength];
                short payloadLength = ArrayUtils.getShort((byte[])msg.msg, (int)(8 + commandNameLength));
                if (type == 1) {
                    String macroName = new String(msg.msg, 10 + commandNameLength, (int)payloadLength);
                    arguments = new InterProcessArgument[]{new InterProcessArgument(commandName), new InterProcessArgument(1), new InterProcessArgument((int)payloadLength), new InterProcessArgument(macroName.getBytes())};
                }
                System.out.println(commandName);
                if (eventHooks.containsKey(commandName)) {
                    InterProcessEvent event = (InterProcessEvent)eventHooks.get(commandName);
                    event.onInterProcessEvent(new EventObject(this), source, commandName, arguments);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onInterProcessEvent(EventObject evt, byte[] source, String command, InterProcessArgument[] args) {
        ProtocolCommandMonitor ipc = (ProtocolCommandMonitor)evt.getSource();
        FileLogger.info("InterProcess Command " + command);
        if (command.equals("macro")) {
            String customCommand = (String)args[0].getValue();
            int type = (Integer)args[1].getValue();
            int length = (Integer)args[2].getValue();
            byte[] value = (byte[])args[3].getValue();
            if (customCommand.equals("macro")) {
                args = new InterProcessArgument[2];
                args[0] = new InterProcessArgument(customCommand);
                String macroName = new String(value);
                MacroResult macroResult = CinemaMain.MacroFile.runMacro(new InterprocessMacroResponse(source, macroName, args), macroName);
                try {
                    args[1] = macroResult.getResult() ? new InterProcessArgument("Macro " + macroName + " Executing...") : new InterProcessArgument("Macro " + macroName + " Failed: " + macroResult.getReason());
                    ipc.writeEntry(113, source, "app_custom_command_response", args);
                }
                catch (Exception ex) {
                    FileLogger.error("Error responding to a run macro interprocess event", ex);
                }
            }
        } else if (command.equals("getOIDValues")) {
            CinemaMain.INSTANCE.getSnmpOidValues();
        } else if (command.equals("app_registration")) {
            System.out.println("Application Registration " + args[0].getValue());
        } else if (command.equals("macro_list")) {
            String customCommand = (String)args[0].getValue();
            StringBuffer sb = new StringBuffer();
            sb.append("{\"macros\" : [");
            int macroCount = CinemaMain.MacroFile.getMacroNames().size();
            for (int i = 0; i < macroCount; ++i) {
                Macro macro = (Macro)CinemaMain.MacroFile.getMacroNumbers().elementAt(i);
                sb.append("\r\n");
                if (i + 1 >= macroCount) continue;
                sb.append(',');
            }
            sb.append("]}");
            try {
                args = new InterProcessArgument[]{new InterProcessArgument(customCommand), new InterProcessArgument(sb.toString())};
                ipc.writeEntry(113, source, "app_custom_command_response", args);
            }
            catch (Exception ex) {
                FileLogger.error("Error responding to a macro_list interprocess event", ex);
            }
        }
    }

    public void writeEntry(int type, byte[] source, String command, InterProcessArgument[] args) {
        try {
            int port = ArrayUtils.getShort((byte[])source, (int)4) & 0xFFFF;
            SystemMsg msg = new SystemMsg();
            msg.type = type;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(source);
            dos.writeByte(1);
            dos.writeByte("app_custom_command_response".length());
            dos.writeBytes("app_custom_command_response");
            dos.writeByte(2);
            dos.writeByte(args[0].getType());
            dos.writeShort(args[0].getLength());
            dos.write(((String)args[0].getValue()).getBytes(), 0, args[0].getLength());
            dos.writeByte(args[1].getType());
            dos.writeShort(args[1].getLength());
            dos.write(((String)args[1].getValue()).getBytes(), 0, args[1].getLength());
            byte[] outBytes = baos.toByteArray();
            msg.msg = outBytes;
            System.out.println("Send to " + source[0] + '.' + source[1] + '.' + source[2] + '.' + source[3] + ":" + port);
            MessagePumpEngine.postMessage(msg);
        }
        catch (Exception ex) {
            FileLogger.error(ex);
        }
    }
}

