/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class DoremiDcp
extends TheatreEthernetDevice {
    private static final byte[] PLAY_BYTES = DoremiDcp.unescapeString("\\x06\\x0e\\x2b\\x34\\x02\\x05\\x01\\x0a\\x0e\\x10\\x01\\x01\\x01\\x03\\x0B\\x00\\x83\\x00\\x00\\x04\\x00\\x00\\x00\\x01");
    private static final byte[] PAUSE_BYTES = DoremiDcp.unescapeString("\\x06\\x0e\\x2b\\x34\\x02\\x05\\x01\\x0a\\x0e\\x10\\x01\\x01\\x01\\x03\\x0D\\x00\\x83\\x00\\x00\\x04\\x00\\x00\\x00\\x01");
    private static final byte[] EJECT_BYTES = DoremiDcp.unescapeString("\\x06\\x0e\\x2b\\x34\\x02\\x05\\x01\\x0a\\x0e\\x10\\x01\\x01\\x01\\x03\\x0F\\x00\\x83\\x00\\x00\\x04\\x00\\x00\\x00\\x01");
    private static final byte[] SHUTDOWN_BYTES = DoremiDcp.unescapeString("\\x06\\x0E\\x2B\\x34\\x02\\x05\\x01\\x0A\\x0E\\x10\\x01\\x01\\x01\\x05\\x17\\x00\\x83\\x00\\x00\\x06\\x00\\x00\\x00\\x01\\x01\\x00");
    private static final byte[] REBOOT_BYTES = DoremiDcp.unescapeString("\\x06\\x0E\\x2B\\x34\\x02\\x05\\x01\\x0A\\x0E\\x10\\x01\\x01\\x01\\x05\\x17\\x00\\x83\\x00\\x00\\x06\\x00\\x00\\x00\\x01\\x02\\x00");

    public DoremiDcp(String name) {
        super(name);
        this.port = "11730";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        FileLogger.info(Config.DEVICES_LOG, "Doremi DCP macro: " + macroName + " (" + macroName.length() + ")");
        if (macroName.equalsIgnoreCase("play")) {
            try {
                if (this.send(PLAY_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Play");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Play");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Play");
            }
        } else if (macroName.equalsIgnoreCase("pause")) {
            try {
                if (this.send(PAUSE_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Pause");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Pause");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Pause");
            }
        } else if (macroName.equalsIgnoreCase("eject")) {
            try {
                if (this.send(EJECT_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Eject");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Eject");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Eject");
            }
        } else if (macroName.equalsIgnoreCase("shutdown")) {
            try {
                if (this.send(SHUTDOWN_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Shutdown");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Shutdown");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Shutdown");
            }
        } else if (macroName.equalsIgnoreCase("reboot")) {
            try {
                if (this.send(REBOOT_BYTES)) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Reboot");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Reboot");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error sending Reboot");
            }
        } else {
            if (macroName.toLowerCase().startsWith("send")) {
                String send = macroName.substring(5);
                String data = null;
                String converted = this.convertHexToString(send);
                data = converted != null ? converted : send;
                if (data == null) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                    return false;
                }
                int dataLen = data.length();
                byte[] dataBytes = new byte[dataLen];
                ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
                return this.send(dataBytes);
            }
            FileLogger.warn("Unknown command");
        }
        return false;
    }

    private int getMacroNumberFromName(String macroName) {
        System.out.println("macro name: " + macroName);
        int lastSpace = macroName.lastIndexOf(32);
        String macroNumberString = macroName.substring(lastSpace + 1);
        System.out.println("last space: " + lastSpace + ", macroNumberString: " + macroNumberString);
        return Integer.parseInt(macroNumberString);
    }

    public synchronized boolean send(byte[] dataBytes) {
        this.ensureConnection();
        boolean success = true;
        try {
            FileLogger.info(Config.DEVICES_LOG, this.name + " Send " + HexUtils.bytesToHex(dataBytes));
            this.bos.reset();
            this.bos.write(dataBytes);
            this.out.write(this.bos.toByteArray());
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            try {
                this.disconnect();
                if (this.ensureConnection()) {
                    this.out.write(this.bos.toByteArray());
                } else {
                    success = false;
                }
            }
            catch (IOException ex2) {
                FileLogger.error(ex2);
                this.disconnect();
                success = false;
            }
        }
        return success;
    }
}

