/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.client.CinemaServerClientHandler;
import com.integpg.cinema.client.JsonClientHandler;
import com.integpg.janoslib.net.tcp.TcpServer;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.logger.FileLogger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class JsonClientTcpServer
implements TcpServerListener {
    public static String JSON_SERVER_LOG = "jsonserver.log";
    private final int _port;
    private TcpServer _tcpServer;
    private Vector clients = new Vector();

    public JsonClientTcpServer(int port) {
        this._port = port;
    }

    public void start() {
        if (null == this._tcpServer) {
            this._tcpServer = new TcpServer("Json Client Server", this._port);
            this._tcpServer.setTcpServerListener(this);
            this._tcpServer.start();
        }
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        try {
            JsonClientHandler handler = new JsonClientHandler(evt.getSocket());
            this.clients.addElement(handler);
            Thread thd = new Thread((Runnable)handler, "JsonClientHandler");
            thd.setDaemon(true);
            thd.start();
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
        catch (Exception ex) {
            FileLogger.error(ex);
        }
    }

    void send(String message) throws IOException {
        Enumeration elements = this.clients.elements();
        while (elements.hasMoreElements()) {
            CinemaServerClientHandler handler = (CinemaServerClientHandler)elements.nextElement();
            handler.send(message);
        }
    }
}

