/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.udp;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.net.IClient;
import com.integpg.janoslib.net.udp.UdpConnectionListener;
import com.integpg.janoslib.net.udp.UdpServerEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UdpServer
implements Runnable,
IClient {
    private final String _name;
    private final int _port;
    private Thread _thd = null;
    private UdpConnectionListener _listener;
    private String _socketInfo;

    public UdpServer(String name, int port) {
        this._name = name;
        this._port = port;
    }

    public void setListener(UdpConnectionListener listener) {
        this._listener = listener;
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName("UDP Server " + this._port);
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        try {
            AppLog.vital("Listening for clients on udp port " + this._port + ".");
            DatagramSocket serverSocket = new DatagramSocket(this._port);
            while (true) {
                byte[] data = new byte[128];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                serverSocket.receive(packet);
                this._socketInfo = packet.getAddress().getHostAddress() + ":" + packet.getPort() + " (udp)";
                data = packet.getData();
                if (null == this._listener) continue;
                this._listener.processMessage(new UdpServerEvent(this, packet));
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void send(String s) {
    }

    @Override
    public String getSocketInfo() {
        return this._socketInfo;
    }
}

