/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class NEC_VT700
extends TheatreSerialDevice {
    private static final byte[] POWER_OFF_BYTES = new byte[]{2, 1, 0, 0, 0, 3};
    private static final byte[] POWER_ON_BYTES = new byte[]{2, 0, 0, 0, 0, 2};
    private static final byte[] PICTURE_MUTE_ON_BYTES = new byte[]{2, 16, 0, 0, 0, 18};
    private static final byte[] PICTURE_MUTE_OFF_BYTES = new byte[]{2, 17, 0, 0, 0, 19};

    public NEC_VT700(String name) {
        super(name);
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        System.out.println("NECVT700 macro: " + macroName);
        if (macroName.toLowerCase().equals("picture mute on")) {
            try {
                this.send(PICTURE_MUTE_ON_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Picture Mute On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Picture Mute On");
            }
        } else if (macroName.toLowerCase().equals("picture mute off")) {
            try {
                this.send(PICTURE_MUTE_OFF_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Picture Mute Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Picture Mute Off");
            }
        } else if (macroName.toLowerCase().equals("power on")) {
            try {
                this.send(POWER_ON_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Power On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power On");
            }
        } else if (macroName.toLowerCase().equals("power off")) {
            try {
                this.send(POWER_OFF_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Power Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power Off");
            }
        } else if (macroName.toLowerCase().startsWith("send")) {
            String send = macroName.substring(5);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            this.send(dataBytes);
        }
        return true;
    }

    public void send(byte[] bytes) {
        if (this.serial == null) {
            this.ensureConnection();
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
    }

    @Override
    public boolean login() {
        return false;
    }
}

