/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.Monitor;

import com.integpg.cinema.Monitor.IOStateListener;
import com.integpg.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integpg.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integpg.janoslib.iolog.IoLogListener;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.logger.FileLogger;
import com.integpg.system.IoEvent;
import java.util.Vector;

public class IOStateMonitor {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public long inputStateMask = 0L;
    public long outputStateMask = 0L;
    protected Vector[] inputListeners = null;
    protected Vector[] outputListeners = null;
    private final DigitalInputsIoLogMonitor _digitalInputsIoLogMonitor = new DigitalInputsIoLogMonitor();
    private final DigitalOutputsIoLogMonitor _digitalOutputsIoLogMonitor = new DigitalOutputsIoLogMonitor();

    public IOStateMonitor() {
        this._digitalInputsIoLogMonitor.addIoLogEventListener(new IoLogListener(){

            @Override
            public void onIoEvent(IoEvent ioEvent) {
                IOStateMonitor.this.inputStateMask = ioEvent.states;
                try {
                    for (int i = 0; i < UnitConfig.getInputCount(); ++i) {
                        int channelMask;
                        int channel = i + 1;
                        if (IOStateMonitor.this.inputListeners[i] == null || (ioEvent.mask & (channelMask = 1 << i)) == 0) continue;
                        IOStateMonitor.this.fireWatcherEvent(IOStateMonitor.this.inputListeners[i], 0, (byte)channel, (byte)(IOStateMonitor.this.inputStateMask >> i & 1L), IOStateMonitor.this.inputStateMask, IOStateMonitor.this.outputStateMask);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void onIoEventsProcessed() {
            }
        });
        this._digitalOutputsIoLogMonitor.addIoLogEventListener(new IoLogListener(){

            @Override
            public void onIoEvent(IoEvent ioEvent) {
                IOStateMonitor.this.outputStateMask = ioEvent.states;
                try {
                    for (int i = 0; i < 16; ++i) {
                        int channelMask;
                        int channel = i + 1;
                        if (IOStateMonitor.this.outputListeners[i] == null || (ioEvent.mask & (channelMask = 1 << i)) == 0) continue;
                        IOStateMonitor.this.fireWatcherEvent(IOStateMonitor.this.outputListeners[i], 1, (byte)channel, (byte)(IOStateMonitor.this.outputStateMask >> i & 1L), IOStateMonitor.this.inputStateMask, IOStateMonitor.this.outputStateMask);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void onIoEventsProcessed() {
            }
        });
    }

    public void removeStateListener(IOStateListener l, int io, int channel) {
        if (io == 0 && --channel < this.inputListeners.length && this.inputListeners[channel] != null && this.inputListeners[channel].contains(l)) {
            this.inputListeners[channel].removeElement(l);
        }
        if (io == 1 && channel < this.outputListeners.length && this.outputListeners[channel] != null && this.outputListeners[channel].contains(l)) {
            this.outputListeners[channel].removeElement(l);
        }
    }

    public void addStateListener(IOStateListener ioStateListener, int io, int channel) {
        try {
            if (io == 0) {
                if (channel > UnitConfig.getInputCount()) {
                    throw new IllegalArgumentException("Channel Out of Range");
                }
                if (this.inputListeners == null) {
                    this.inputListeners = new Vector[UnitConfig.getInputCount()];
                }
                if (this.inputListeners[channel - 1] == null) {
                    this.inputListeners[channel - 1] = new Vector();
                }
                if (!this.inputListeners[channel - 1].contains(ioStateListener)) {
                    this.inputListeners[channel - 1].addElement(ioStateListener);
                    this._digitalInputsIoLogMonitor.start();
                }
            } else if (io == 1) {
                if (channel > 16) {
                    throw new IllegalArgumentException("Channel Out of Range");
                }
                if (this.outputListeners == null) {
                    this.outputListeners = new Vector[16];
                }
                if (this.outputListeners[channel - 1] == null) {
                    this.outputListeners[channel - 1] = new Vector();
                }
                if (!this.outputListeners[channel - 1].contains(ioStateListener)) {
                    this.outputListeners[channel - 1].addElement(ioStateListener);
                    this._digitalOutputsIoLogMonitor.start();
                }
            }
        }
        catch (Exception ex) {
            FileLogger.error("error adding an io state monitor", ex);
        }
    }

    public void start() {
    }

    private void fireWatcherEvent(Vector v, int io, byte channel, byte state, long inputMask, long outputMask) {
        channel = (byte)(channel - 1);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            try {
                IOStateListener l = (IOStateListener)v.elementAt(i);
                if (l == null) continue;
                l.ioStateChange(io, (byte)(channel + 1), state, inputMask, outputMask);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

