/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.CinemaIO;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.InterProcess.InterProcessArgument;
import com.integpg.cinema.InterProcess.InterProcessEvent;
import com.integpg.cinema.Logic;
import com.integpg.cinema.Monitor.IOStateListener;
import com.integpg.cinema.client.MessageEvent;
import com.integpg.cinema.client.MessageRepeater;
import com.integpg.cinema.client.MessageRepeaterListener;
import com.integpg.cinema.client.PreshowClient;
import com.integpg.cinema.client.PreshowClientTcpServer;
import com.integpg.cinema.client.PreshowStartMaskingMode;
import com.integpg.cinema.configuration.PreshowClientManualMaskingConfiguration;
import com.integpg.cinema.devices.Barco;
import com.integpg.cinema.devices.BarcoStatus;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.cinema.firealarm.FireAlarm;
import com.integpg.cinema.firealarm.FireAlarmListener;
import com.integpg.cinema.macro.InternalIOAction;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.internalio.IOChangedListener;
import com.integpg.janoslib.internalio.IOMonitor;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Timer;

public class PreshowClientHandler
implements Runnable,
IOStateListener,
MacroRequestListener,
InterProcessEvent,
MessageRepeaterListener,
FireAlarmListener {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff");
    private static final int CLIENT_BUFFER_BYTES = 1024;
    private static final String RUN = "run";
    private static final String GET = "get";
    public static String START_PRESHOW_COMMAND = "start_preshow";
    public static String START_3D = "start_3d";
    private static final String MID_PRESHOW = "mid_preshow";
    public static String END_PRESHOW = "end_preshow";
    private static final String LAMP_RELAY_CLOSE = "lamp_relay_close";
    private static final String LAMP_RELAY_OPEN = "lamp_relay_open";
    private static final String PRESHOW_STATUS = "preshow_status";
    private static final String FIRE_ALARM_STATUS = "fire_alarm_status";
    private static final String MOVIE_STATUS = "movie_status";
    private static final String PRESHOW_LAMP_STATUS = "preshow_lamp_status";
    private static final String PROJECTOR_STATUS = "projector_status";
    private static final String INVALID_COMMAND = "invalid_command";
    public static final String MOVIE_ON = "movie_on";
    public static final String MOVIE_OFF = "movie_off";
    private static final String PRESHOW_TIMER_EXPIRED = "exception_message_1";
    private static final String FAILSAFE_TIMER_EXPIRED = "exception_message_2";
    public static final String FIRE_ALARM = "fire_alarm";
    public static final String PUSH_BUTTON = "push_button";
    public static final String LAMP_RELAY_UNDEFINED = "lamp_relay_undefined";
    public static final String PRESHOW_LAMP_ON = "preshow_lamp_on";
    public static final String PRESHOW_LAMP_OFF = "preshow_lamp_off";
    public static final String PRESHOW_ENABLED = "preshow_enabled";
    public static final String PRESHOW_DISABLED = "preshow_disabled";
    public static final String FIRE_ALARM_ACTIVE = "fire_alarm_active";
    public static final String FIRE_ALARM_INACTIVE = "fire_alarm_inactive";
    private PreshowClient m_parent = null;
    private InputStream m_inStream;
    private OutputStream m_outStream;
    private Socket m_socket;
    private String _clientInfo;
    private StringBuffer sendBuffer = new StringBuffer(64);
    private Thread _preshowTimer;
    private Thread _failSafeTimer;
    private Thread _pushButtonFailSafeTimer;
    private boolean gracefulEndOfPreshow = false;
    private boolean gracefulEndOfPreshowPause = false;
    private boolean m_preshowFlag = false;
    private boolean _fireAlarm = false;
    private boolean _pushButtonPreshowFlag = false;
    private MessageRepeater _movieStatusRepeater;
    private MessageRepeater _preshowClientStatusRepeater;
    private MessageRepeater _fireAlarmStatusRepeater;
    private String _macroCause = "";
    PreshowClientTcpServer _server = null;
    private Timer _timer = new Timer(true);
    private long _pushButtonDebounceClearTime = 0L;

    public PreshowClientHandler(PreshowClient parent, InputStream inputStream, OutputStream outputStream) {
        this(parent, inputStream, outputStream, null, null);
        CinemaMain.INSTANCE.fireAlarm.addListener(this);
    }

    public PreshowClientHandler(PreshowClient parent, InputStream inputStream, OutputStream outputStream, Socket socket, PreshowClientTcpServer server) {
        int i;
        this.m_parent = parent;
        this.m_inStream = inputStream;
        this.m_outStream = outputStream;
        this.m_socket = socket;
        this._server = server;
        this._clientInfo = this.m_socket != null ? this.m_socket.getInetAddress().getHostAddress() + ":" + this.m_socket.getPort() : parent.CLIENT_METHOD;
        IOMonitor.addListener(new IOChangedListener(){

            @Override
            public void ioChanged(EventObject event) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        for (i = 1; i <= UnitConfig.getInputCount(); ++i) {
            CinemaMain.INSTANCE.m_stateMonitor.addStateListener(this, 0, i);
        }
        for (i = 1; i <= 16; ++i) {
            CinemaMain.INSTANCE.m_stateMonitor.addStateListener(this, 1, i);
        }
        this._movieStatusRepeater = new MessageRepeater(this._timer, this);
        this._preshowClientStatusRepeater = new MessageRepeater(this._timer, this);
        this._fireAlarmStatusRepeater = new MessageRepeater(this._timer, this);
    }

    @Override
    public void run() {
        FileLogger.info(PreshowClient.CLIENT_LOG, "Client Connected: " + this._clientInfo);
        byte[] bytes = new byte[1024];
        byte[] TERMINATION_BYTES = this.m_parent.CLIENT_INCOMING_TERMINATION_BYTES;
        boolean quit = false;
        while (!quit) {
            try {
                while (this.m_inStream == null || this.m_outStream == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        FileLogger.error(ex);
                    }
                }
                StringBuffer sb = new StringBuffer(64);
                boolean execute = false;
                if (this.m_socket == null) {
                    try {
                        this.m_inStream.skip(this.m_inStream.available());
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                }
                try {
                    if (this.m_parent.VENDOR != 1) {
                        this.send("client_connected");
                    }
                }
                catch (IOException ex) {
                    FileLogger.error(ex);
                }
                if (PreshowClient.MOVIE_OFF_STATUS_FREQ != null) {
                    if (PreshowClient.MOVIE_OFF_STATUS_FREQ.length == 2) {
                        this._movieStatusRepeater.start(MOVIE_OFF, Integer.parseInt(PreshowClient.MOVIE_OFF_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.MOVIE_OFF_STATUS_FREQ[1]));
                    }
                }
                if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
                    if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                        this._preshowClientStatusRepeater.start("preshow_inactive", Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
                    }
                }
                int terminationStringOffset = 0;
                while (true) {
                    try {
                        int offset = 0;
                        block22: while (!execute) {
                            int bytesRead;
                            if (this.m_socket == null) {
                                while (this.m_inStream.available() == 0) {
                                    Thread.sleep(250L);
                                }
                            }
                            if (1024 == offset) {
                                FileLogger.info("Assume client would have failed ");
                                offset = 0;
                            }
                            if ((bytesRead = this.m_inStream.read(bytes, offset, 1024 - offset)) == -1) {
                                throw new IOException("No bytes read");
                            }
                            for (int i = 0; i < bytesRead; ++i) {
                                byte b = bytes[offset];
                                ++offset;
                                if (b == -1) {
                                    if (this.m_socket == null) continue block22;
                                    throw new IOException();
                                }
                                char keystroke = (char)(b & 0x7F);
                                if (keystroke == TERMINATION_BYTES[terminationStringOffset]) {
                                    if (++terminationStringOffset != TERMINATION_BYTES.length) continue;
                                    if (sb.length() > 0 && (execute = true)) {
                                        this.execute(sb);
                                        sb.setLength(0);
                                        execute = false;
                                        try {
                                            Thread.sleep(10L);
                                        }
                                        catch (InterruptedException ex) {
                                            FileLogger.error(ex);
                                        }
                                    }
                                    terminationStringOffset = 0;
                                    if (i + 1 != bytesRead) continue;
                                    offset = 0;
                                    continue block22;
                                }
                                terminationStringOffset = 0;
                                if (keystroke < ' ' || keystroke > '~') continue;
                                sb.append(keystroke);
                            }
                        }
                    }
                    catch (EOFException ex) {
                        quit = true;
                        break;
                    }
                    catch (IOException ex) {
                        System.out.println("Client Comm Closed by Client");
                        System.out.println(sb.toString() + " was read");
                        try {
                            if (this.m_inStream != null) {
                                this.m_inStream.close();
                                this.m_inStream = null;
                            }
                            if (this.m_outStream != null) {
                                this.m_outStream.close();
                                this.m_outStream = null;
                            }
                            if (this.m_socket != null) {
                                this.m_socket.close();
                                this.m_socket = null;
                            }
                        }
                        catch (IOException ex1) {
                            FileLogger.error(ex1);
                        }
                        this._server.removeClientHandler(this);
                        for (int i = 1; i <= 16; ++i) {
                            CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 0, i);
                            CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 1, i);
                        }
                        quit = true;
                        break;
                    }
                    this._server.removeClientHandler(this);
                }
                try {
                    if (this.m_inStream != null) {
                        this.m_inStream.close();
                        this.m_inStream = null;
                    }
                    if (this.m_outStream != null) {
                        this.m_outStream.close();
                        this.m_outStream = null;
                    }
                    if (this.m_socket != null) {
                        this.m_socket.close();
                        this.m_socket = null;
                    }
                    for (int i = 1; i <= 16; ++i) {
                        CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 0, i);
                        CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 1, i);
                    }
                    this._server.removeClientHandler(this);
                    quit = true;
                }
                catch (IOException ex) {
                    FileLogger.error(ex);
                }
            }
            catch (Exception ex) {
                FileLogger.error(ex);
                try {
                    if (this.m_inStream != null) {
                        this.m_inStream.close();
                        this.m_inStream = null;
                    }
                    if (this.m_outStream != null) {
                        this.m_outStream.close();
                        this.m_outStream = null;
                    }
                    if (this.m_socket != null) {
                        this.m_socket.close();
                        this.m_socket = null;
                    } else {
                        FileLogger.info("Client run: " + ex.toString());
                    }
                    for (int i = 1; i <= 16; ++i) {
                        CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 0, i);
                        CinemaMain.INSTANCE.m_stateMonitor.removeStateListener(this, 1, i);
                    }
                    this._server.removeClientHandler(this);
                    quit = true;
                }
                catch (IOException ex1) {
                    FileLogger.error(ex1);
                }
            }
        }
        FileLogger.info(PreshowClient.CLIENT_LOG, "Client Disconnected: " + this._clientInfo);
        if (this._movieStatusRepeater != null) {
            this._movieStatusRepeater.cancel();
            this._movieStatusRepeater = null;
        }
        if (this._fireAlarmStatusRepeater != null) {
            this._fireAlarmStatusRepeater.cancel();
            this._fireAlarmStatusRepeater = null;
        }
        if (this._preshowClientStatusRepeater != null) {
            this._preshowClientStatusRepeater.cancel();
            this._preshowClientStatusRepeater = null;
        }
        this._timer.cancel();
    }

    public void execute(StringBuffer sb) throws IOException {
        String line = sb.toString();
        if (PreshowClient.CLIENT_USE_LOG) {
            FileLogger.info(PreshowClient.CLIENT_LOG, "From Client: " + line);
        }
        if (CinemaIO.getPreshowLock() != 1 && FireAlarm.m_fireAlarm != 1) {
            if (this.m_parent.ALLOW_QUERY && (line.startsWith(GET) || line.startsWith(RUN))) {
                int pos = line.indexOf(32);
                if (pos > 0) {
                    String command = line.substring(0, pos).trim();
                    String params = line.substring(pos + 1).trim();
                    this.commandReceived(command, params);
                } else if (this.m_parent.VENDOR != 1) {
                    this.send(INVALID_COMMAND, false);
                }
            } else if (this.m_parent.CLIENT_IO_ENABLED && line.startsWith("::")) {
                InternalIOAction.parseCommand(line.substring(2));
            } else if (line.equals(START_PRESHOW_COMMAND)) {
                if (PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ != null) {
                    if (PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ.length == 2) {
                        this._preshowClientStatusRepeater.start("preshow_active", Integer.parseInt(PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ[1]));
                    }
                }
                this.m_preshowFlag = true;
                this.gracefulEndOfPreshow = false;
                this.gracefulEndOfPreshowPause = false;
                this._macroCause = "preshow_start";
                if (PreshowStartMaskingMode.getMaskingMode() == PreshowStartMaskingMode.MASKING_MODE.DISABLED) {
                    this.commandReceived(RUN, this.m_parent.PRESHOW_START_MACRO);
                } else if (PreshowStartMaskingMode.getMaskingMode() == PreshowStartMaskingMode.MASKING_MODE.FLAT && !PreshowClientManualMaskingConfiguration.getPreshowStartFlatMacro().equals("none")) {
                    this.commandReceived(RUN, PreshowClientManualMaskingConfiguration.getPreshowStartFlatMacro());
                } else if (PreshowStartMaskingMode.getMaskingMode() == PreshowStartMaskingMode.MASKING_MODE.SCOPE && !PreshowClientManualMaskingConfiguration.getPreshowStartScopeMacro().equals("none")) {
                    this.commandReceived(RUN, PreshowClientManualMaskingConfiguration.getPreshowStartScopeMacro());
                } else {
                    this.commandReceived(RUN, this.m_parent.PRESHOW_START_MACRO);
                }
            } else if (line.equals(START_3D)) {
                if (!this.m_parent.START_3D_MACRO.equalsIgnoreCase("none")) {
                    this._macroCause = "start_3d";
                    this.commandReceived(RUN, this.m_parent.START_3D_MACRO);
                }
            } else if (line.equals(MID_PRESHOW)) {
                String midPreshowMacroName;
                if (PreshowClient.FIVE_MIN_TIMER) {
                    try {
                        this._preshowTimer = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileLogger.info("Preshow timer STARTED");
                                    Thread.sleep(300000L);
                                    if (!PreshowClientHandler.this.gracefulEndOfPreshow) {
                                        if (((PreshowClientHandler)PreshowClientHandler.this).m_parent.VENDOR != 1) {
                                            PreshowClientHandler.this.send(PreshowClientHandler.PRESHOW_TIMER_EXPIRED);
                                        }
                                        PreshowClientHandler.this.endPreshow(true);
                                    }
                                    FileLogger.info("Preshow timer FINISHED");
                                    PreshowClientHandler.this._preshowTimer = null;
                                }
                                catch (InterruptedException ex) {
                                    FileLogger.info("Preshow timer ABORTED");
                                }
                                catch (IOException ex) {
                                    FileLogger.error(ex);
                                }
                            }
                        }, "Mid Preshow Timer");
                        this._preshowTimer.start();
                    }
                    catch (RuntimeException ex) {
                        FileLogger.error("Too many threads", ex);
                    }
                }
                if (!"none".equalsIgnoreCase(midPreshowMacroName = PreshowClient.getMidPreshowMacro())) {
                    this._macroCause = MID_PRESHOW;
                    this.commandReceived(RUN, midPreshowMacroName);
                }
            } else if (line.equals(END_PRESHOW)) {
                this.gracefulEndOfPreshow = true;
                this.gracefulEndOfPreshowPause = true;
                if (this._preshowTimer != null) {
                    this._preshowTimer.interrupt();
                }
                if (this._failSafeTimer != null) {
                    this._failSafeTimer.interrupt();
                }
                this.endPreshow(true);
            } else if (this.m_parent.ALLOW_QUERY && line.equals(LAMP_RELAY_CLOSE)) {
                if (PreshowClient.PRESHOW_LAMP_OUTPUT == -1) {
                    if (this.m_parent.VENDOR != 1) {
                        this.send(LAMP_RELAY_UNDEFINED);
                    }
                } else {
                    int lampState = CinemaIO.getPreshowLamp();
                    if (lampState == 1) {
                        if (this.m_parent.VENDOR != 1) {
                            this.send(PRESHOW_LAMP_ON);
                        }
                    } else {
                        CinemaMain.INSTANCE.cinemaio.setOutputStates(1 << PreshowClient.PRESHOW_LAMP_OUTPUT - 1, 1 << PreshowClient.PRESHOW_LAMP_OUTPUT - 1);
                    }
                }
            } else if (this.m_parent.ALLOW_QUERY && line.equals(LAMP_RELAY_OPEN)) {
                if (PreshowClient.PRESHOW_LAMP_OUTPUT == -1) {
                    if (this.m_parent.VENDOR != 1) {
                        this.send(LAMP_RELAY_UNDEFINED);
                    }
                } else {
                    int lampState = CinemaIO.getPreshowLamp();
                    if (lampState == 1) {
                        CinemaMain.INSTANCE.cinemaio.setOutputStates(0L, 1 << PreshowClient.PRESHOW_LAMP_OUTPUT - 1);
                    } else if (this.m_parent.VENDOR != 1) {
                        this.send(PRESHOW_LAMP_OFF);
                    }
                }
                if (!this.m_parent.LAMP_RELAY_OPEN_MACRO.equals("")) {
                    this.commandReceived(RUN, this.m_parent.LAMP_RELAY_OPEN_MACRO);
                }
            } else if (PreshowClient._logicRulesByCommand.containsKey(line)) {
                long start = JANOS.uptimeMillis();
                Logic logic = (Logic)PreshowClient._logicRulesByCommand.get(line);
                int result = logic.evaluate(JANOS.getInputStates(), JANOS.getOutputStates());
                if (result == 1) {
                    logic.execute();
                }
                long l = JANOS.uptimeMillis() - start;
            } else {
                int pos = line.indexOf(32);
                if (pos > 0) {
                    String params;
                    String command = line.substring(0, pos).trim();
                    if (!this.commandReceived(command, params = line.substring(pos + 1).trim())) {
                        this.send(INVALID_COMMAND, false);
                    }
                } else {
                    this.send(INVALID_COMMAND, false);
                }
            }
        } else {
            String command;
            boolean get = false;
            int pos = line.indexOf(32);
            if (pos > 0 && (command = line.substring(0, pos).trim()).toLowerCase().equals(GET)) {
                get = true;
                String params = line.substring(pos + 1).trim();
                this.commandReceived(command, params);
            }
            if (!get) {
                if (CinemaIO.getMovieStatus() == 1) {
                    this.send("movie_on (" + line + ")");
                } else if (FireAlarm.m_fireAlarm == 1) {
                    if (this.m_parent.VENDOR != 1) {
                        this.send("movie_on (" + line + ")\r\n" + FIRE_ALARM);
                    } else {
                        this.send("movie_on (" + line + ")");
                    }
                }
            }
        }
    }

    public boolean commandReceived(String command, String params) {
        return this.commandReceived(command, params, true);
    }

    public boolean commandReceived(String command, String params, boolean checkPreshowLock) {
        boolean result;
        block43: {
            result = false;
            if (command.equals(RUN)) {
                result = CinemaMain.MacroFile.runMacro(this, params, checkPreshowLock).getResult();
            } else if (this.m_parent.ALLOW_QUERY && command.equals(GET)) {
                if (params.equals(MOVIE_STATUS)) {
                    try {
                        if (CinemaIO.getMovieStatus() == 1) {
                            this.send(MOVIE_ON);
                        } else if (FireAlarm.m_fireAlarm == 1) {
                            if (this.m_parent.VENDOR != 1) {
                                this.send("movie_on\r\nfire_alarm");
                            } else {
                                this.send(MOVIE_ON);
                            }
                        } else {
                            this.send(MOVIE_OFF);
                        }
                        result = true;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                } else if (params.equals(PRESHOW_STATUS)) {
                    try {
                        if (this.m_preshowFlag) {
                            this.send(PRESHOW_ENABLED);
                        } else {
                            this.send(PRESHOW_DISABLED);
                        }
                        result = true;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                } else if (params.equals(FIRE_ALARM_STATUS)) {
                    try {
                        if (FireAlarm.m_fireAlarm == 1) {
                            this.send(FIRE_ALARM_ACTIVE);
                        } else {
                            this.send(FIRE_ALARM_INACTIVE);
                        }
                        result = true;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                } else if (params.equals(PRESHOW_LAMP_STATUS)) {
                    try {
                        if (PreshowClient.PRESHOW_LAMP_OUTPUT == -1) {
                            this.send(LAMP_RELAY_UNDEFINED);
                        } else {
                            int lampState = CinemaIO.getPreshowLamp();
                            if (lampState == 1) {
                                this.send(PRESHOW_LAMP_ON);
                            } else {
                                this.send(PRESHOW_LAMP_OFF);
                            }
                        }
                        result = true;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                } else if (params.equals(PROJECTOR_STATUS)) {
                    try {
                        System.out.println(PROJECTOR_STATUS);
                        Hashtable ht = TheatreDevice.getProjectors();
                        if (ht.size() > 1) {
                            this.send("Too many projectors.  Can not query", false);
                            break block43;
                        }
                        Enumeration projectors = ht.elements();
                        Barco barco = null;
                        try {
                            barco = (Barco)projectors.nextElement();
                        }
                        catch (ClassCastException ex) {
                            this.send("Projector Status not implemented for " + ht.keys().nextElement(), false);
                        }
                        if (barco == null) break block43;
                        BarcoStatus ps = barco.getStatus();
                        if (ps == null) {
                            this.send("Could not query projector.  Check devices.log", false);
                            break block43;
                        }
                        String status = (ps.lampOn ? "projector_lamp_on" : "projector_lamp_off") + (ps.dowserOpen ? ", projector_dowser_open" : ", projector_dowser_closed") + ", projector_last_macro:" + ps.lastMacroExecuted;
                        this.send(status, true);
                        result = true;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                } else {
                    try {
                        this.send("Invalid Get Request", false);
                        result = true;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                }
            }
        }
        return result;
    }

    public synchronized void send(String s) throws IOException {
        this.send(s, true);
    }

    public synchronized void send(String s, boolean ack) throws IOException {
        long ts = System.currentTimeMillis();
        this.sendBuffer.setLength(0);
        if (this.m_parent.CLIENT_SEND_ACK) {
            if (ack) {
                this.sendBuffer.append("+ ");
            } else {
                this.sendBuffer.append("- ");
            }
        }
        this.sendBuffer.append(s);
        s = this.sendBuffer.toString();
        byte[] b = s.getBytes();
        if (this.m_outStream != null) {
            try {
                if (this.m_parent.CLIENT_SEND_DATESTAMP) {
                    this.m_outStream.write(QUICK_DATE_FORMAT.format(ts).getBytes());
                    this.m_outStream.write(32);
                }
                this.m_outStream.write(b);
                this.m_outStream.write(this.m_parent.CLIENT_OUTGOING_TERMINATION_BYTES);
                this.m_outStream.flush();
                if (PreshowClient.CLIENT_USE_LOG) {
                    FileLogger.info(PreshowClient.CLIENT_LOG, "  To Client: " + s);
                }
            }
            catch (Exception ex) {
                FileLogger.warn("unable to write to cinema server client");
            }
        } else {
            if (PreshowClient.CLIENT_USE_LOG) {
                FileLogger.error(PreshowClient.CLIENT_LOG, "NO OUTPUT STREAM TO WRITE TO");
            }
            if (this._movieStatusRepeater != null) {
                this._movieStatusRepeater.cancel();
                this._movieStatusRepeater = null;
            }
            if (this._fireAlarmStatusRepeater != null) {
                this._fireAlarmStatusRepeater.cancel();
                this._fireAlarmStatusRepeater = null;
            }
            if (this._preshowClientStatusRepeater != null) {
                this._preshowClientStatusRepeater.cancel();
                this._preshowClientStatusRepeater = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputStateMask, long outputStateMask) {
        block28: {
            block30: {
                block29: {
                    if (io != 0) break block29;
                    if (PreshowClient.PRESHOW_START_PUSHBUTTON_INPUT == -1) break block29;
                    if (channel != PreshowClient.PRESHOW_START_PUSHBUTTON_INPUT) break block29;
                    try {
                        if (CinemaIO.getMovieStatus() != 0 || state != 1 || JANOS.uptimeMillis() <= this._pushButtonDebounceClearTime) break block28;
                        this._pushButtonDebounceClearTime = JANOS.uptimeMillis() + (long)(this.m_parent.PUSH_BUTTON_DEBOUNCE_TIME * 1000);
                        System.out.println("Push Button Debounce Time " + this.m_parent.PUSH_BUTTON_DEBOUNCE_TIME * 1000 + " = " + this._pushButtonDebounceClearTime);
                        this.send("push_button");
                        if (this.m_parent.PUSH_BOTTON_EXECUTE_MACROS) {
                            if (!this._pushButtonPreshowFlag) {
                                this._macroCause = "preshow_start";
                                this.commandReceived("run", this.m_parent.START_PRESHOW_TEST_MACRO);
                                this.m_preshowFlag = true;
                                this._pushButtonPreshowFlag = true;
                                if (PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ != null) {
                                    if (PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ.length == 2) {
                                        this._preshowClientStatusRepeater.start("preshow_active", Integer.parseInt(PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ[1]));
                                    }
                                }
                                this.startPushButtonFailSafeTimer();
                            } else {
                                this._macroCause = "preshow_end";
                                this.commandReceived("run", this.m_parent.END_PRESHOW_TEST_MACRO);
                                this.m_preshowFlag = false;
                                this._pushButtonPreshowFlag = false;
                                if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
                                    if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                                        this._preshowClientStatusRepeater.start("preshow_inactive", Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
                                    }
                                }
                            }
                        }
                        break block28;
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                    break block28;
                }
                if (io != 1) break block30;
                if (channel != PreshowClient.PRESHOW_LOCK_OUTPUT) break block30;
                try {
                    block31: {
                        CinemaIO.setPreshowLock(state);
                        if (CinemaIO.getPreshowLock() != 1) break block31;
                        if (PreshowClient.MOVIE_ON_STATUS_FREQ == null) ** GOTO lbl-1000
                        if (PreshowClient.MOVIE_ON_STATUS_FREQ.length == 2) {
                            this._movieStatusRepeater.start("movie_on", Integer.parseInt(PreshowClient.MOVIE_ON_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.MOVIE_ON_STATUS_FREQ[1]));
                        } else if (this.m_parent.VENDOR != 1) {
                            this.send("movie_on");
                        }
                        CinemaMain.INSTANCE.setSnmpOidValue("1.3.6.1.4.1.31976.2.2.2.0", 1, Config.COMMUNITY_NAME);
                        this.m_preshowFlag = false;
                        if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
                            if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                                this._preshowClientStatusRepeater.start("preshow_inactive", Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
                            }
                        }
                        break block28;
                    }
                    if (PreshowClient.MOVIE_OFF_STATUS_FREQ == null) ** GOTO lbl-1000
                    if (PreshowClient.MOVIE_OFF_STATUS_FREQ.length == 2) {
                        this._movieStatusRepeater.start("movie_off", Integer.parseInt(PreshowClient.MOVIE_OFF_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.MOVIE_OFF_STATUS_FREQ[1]));
                    } else if (this.m_parent.VENDOR != 1) {
                        this.send("movie_off");
                    }
                    CinemaMain.INSTANCE.setSnmpOidValue("1.3.6.1.4.1.31976.2.2.2.0", 0, Config.COMMUNITY_NAME);
                }
                catch (IOException ex) {
                    FileLogger.error(ex);
                }
                break block28;
            }
            if (io != 1) ** GOTO lbl-1000
            if (channel == PreshowClient.PRESHOW_LAMP_OUTPUT) {
                CinemaIO.setPreshowLamp(state);
                try {
                    if (state == 1) {
                        if (this.m_parent.VENDOR != 1) {
                            this.send("preshow_lamp_on");
                        }
                        CinemaMain.INSTANCE.setSnmpOidValue("1.3.6.1.4.1.31976.2.2.3.0", 1, Config.COMMUNITY_NAME);
                        break block28;
                    }
                    if (this.m_parent.VENDOR != 1) {
                        this.send("preshow_lamp_off");
                    }
                    CinemaMain.INSTANCE.setSnmpOidValue("1.3.6.1.4.1.31976.2.2.3.0", 0, Config.COMMUNITY_NAME);
                }
                catch (IOException ex) {
                    FileLogger.error(ex);
                }
            } else if (io == 0) {
                if (channel == PreshowClient.FAIL_SAFE_INPUT_TRIGGER && state == 1) {
                    this.startFailSafeTimer();
                }
            }
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        try {
            FileLogger.info(macroResult.getReason());
            System.out.println(macroResult.getReason());
            System.out.println(macroResult.getResult());
            if (this._macroCause.equals("preshow_start") && macroResult.getResult() && !this.m_parent.PRESHOW_START_SUCCESS_RESPONSE.equals("none")) {
                this.send(this.m_parent.PRESHOW_START_SUCCESS_RESPONSE, macroResult.getResult());
            } else if (this._macroCause.equals("preshow_start") && !macroResult.getResult() && !this.m_parent.PRESHOW_START_FAILED_RESPONSE.equals("none")) {
                this.send(this.m_parent.PRESHOW_START_FAILED_RESPONSE, macroResult.getResult());
            } else if (this._macroCause.equalsIgnoreCase("start_3d") && macroResult.getResult() && !this.m_parent.START_3D_SUCCESS_RESPONSE.equals("none")) {
                this.send(this.m_parent.START_3D_SUCCESS_RESPONSE, macroResult.getResult());
            } else if (this._macroCause.equalsIgnoreCase("start_3d") && !macroResult.getResult() && !this.m_parent.START_3D_FAILED_RESPONSE.equals("none")) {
                this.send(this.m_parent.START_3D_FAILED_RESPONSE, macroResult.getResult());
            } else if (this._macroCause.equals("preshow_end") && macroResult.getResult() && !this.m_parent.PRESHOW_END_SUCCESS_RESPONSE.equals("none")) {
                this.send(this.m_parent.PRESHOW_END_SUCCESS_RESPONSE, macroResult.getResult());
            } else if (this._macroCause.equals("preshow_end") && !macroResult.getResult() && !this.m_parent.PRESHOW_END_FAILED_RESPONSE.equals("none")) {
                if (CinemaIO.getPreshowLock() == 1) {
                    this.send(this.m_parent.PRESHOW_END_ABORTED_RESPONSE, macroResult.getResult());
                } else {
                    this.send(this.m_parent.PRESHOW_END_FAILED_RESPONSE, macroResult.getResult());
                }
            } else {
                this.send(macroResult.getReason(), macroResult.getResult());
            }
            this._macroCause = "";
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }

    private void endPreshow(boolean checkPreshowLock) throws IOException {
        this._macroCause = "preshow_end";
        this.commandReceived(RUN, this.m_parent.PRESHOW_END_MACRO, checkPreshowLock);
        if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
            if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                this._preshowClientStatusRepeater.start("preshow_inactive", Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
            }
        }
        this.m_preshowFlag = false;
    }

    private void startPushButtonFailSafeTimer() {
        if (this.m_parent.PUSH_BUTTON_FAIL_SAFE_DURATION > 0) {
            try {
                this._pushButtonFailSafeTimer = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileLogger.info("Push Button Fail Safe timer STARTED: " + ((PreshowClientHandler)PreshowClientHandler.this).m_parent.PUSH_BUTTON_FAIL_SAFE_DURATION);
                            Thread.sleep(((PreshowClientHandler)PreshowClientHandler.this).m_parent.PUSH_BUTTON_FAIL_SAFE_DURATION * 60000);
                            PreshowClientHandler.this._macroCause = "preshow_end";
                            PreshowClientHandler.this.commandReceived(PreshowClientHandler.RUN, ((PreshowClientHandler)PreshowClientHandler.this).m_parent.END_PRESHOW_TEST_MACRO);
                            PreshowClientHandler.this.m_preshowFlag = false;
                            PreshowClientHandler.this._pushButtonPreshowFlag = false;
                            PreshowClientHandler.this.m_parent;
                            if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
                                PreshowClientHandler.this.m_parent;
                                if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                                    MessageRepeater messageRepeater = PreshowClientHandler.this._preshowClientStatusRepeater;
                                    PreshowClientHandler.this.m_parent;
                                    int n = Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]);
                                    PreshowClientHandler.this.m_parent;
                                    messageRepeater.start("preshow_inactive", n, Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
                                }
                            }
                            FileLogger.info("Push Button Fail Safe timer FINISHED");
                        }
                        catch (InterruptedException ex) {
                            FileLogger.info("Push Button Fail Safe timer ABORTED");
                        }
                        catch (Exception ex) {
                            FileLogger.error(ex);
                        }
                        finally {
                            PreshowClientHandler.this._pushButtonFailSafeTimer = null;
                        }
                    }
                }, "Push Button Fail Safe Timer");
                this._pushButtonFailSafeTimer.start();
            }
            catch (RuntimeException ex) {
                FileLogger.error("Cinema.jnior: Pushbutton Timer Too Many Threads.", ex);
            }
        }
    }

    private void startFailSafeTimer() {
        try {
            this._failSafeTimer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PreshowClientHandler.this.gracefulEndOfPreshowPause = false;
                        StringBuilder stringBuilder = new StringBuilder().append("Fail Safe timer STARTED: ");
                        PreshowClientHandler.this.m_parent;
                        FileLogger.info(stringBuilder.append(PreshowClient.FAIL_SAFE_TIMER_DURATION).toString());
                        PreshowClientHandler.this.m_parent;
                        Thread.sleep(PreshowClient.FAIL_SAFE_TIMER_DURATION * 1000);
                        System.out.println("Graceful end? " + PreshowClientHandler.this.gracefulEndOfPreshowPause);
                        if (!PreshowClientHandler.this.gracefulEndOfPreshowPause) {
                            if (((PreshowClientHandler)PreshowClientHandler.this).m_parent.VENDOR != 1) {
                                PreshowClientHandler.this.send(PreshowClientHandler.FAILSAFE_TIMER_EXPIRED);
                            }
                            PreshowClientHandler.this.endPreshow(false);
                        }
                        FileLogger.info("Fail Safe timer FINISHED");
                    }
                    catch (InterruptedException ex) {
                        FileLogger.info("Fail Safe timer ABORTED");
                    }
                    catch (Exception ex) {
                        FileLogger.error(ex);
                    }
                    finally {
                        PreshowClientHandler.this._failSafeTimer = null;
                    }
                }
            }, "Fail Safe Timer");
            this._failSafeTimer.start();
        }
        catch (RuntimeException ex) {
            FileLogger.error("Cinema.jnior: Fail Safe Timer Too Many Threads.", ex);
        }
    }

    public void timerConfigUpdated() {
        System.out.println("Timer Config Updated");
        if (this.m_preshowFlag) {
            if (PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ != null) {
                if (PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ.length == 2) {
                    this._preshowClientStatusRepeater.start("preshow_active", Integer.parseInt(PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_ACTIVE_STATUS_FREQ[1]));
                }
            }
        } else if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
            if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                this._preshowClientStatusRepeater.start("preshow_inactive", Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
            }
        }
        if (CinemaIO.getMovieStatus() == 1) {
            if (PreshowClient.MOVIE_ON_STATUS_FREQ != null) {
                if (PreshowClient.MOVIE_ON_STATUS_FREQ.length == 2) {
                    this._movieStatusRepeater.start(MOVIE_ON, Integer.parseInt(PreshowClient.MOVIE_ON_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.MOVIE_ON_STATUS_FREQ[1]));
                }
            }
        } else if (PreshowClient.MOVIE_OFF_STATUS_FREQ != null) {
            if (PreshowClient.MOVIE_OFF_STATUS_FREQ.length == 2) {
                this._movieStatusRepeater.start(MOVIE_OFF, Integer.parseInt(PreshowClient.MOVIE_OFF_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.MOVIE_OFF_STATUS_FREQ[1]));
            }
        }
        if (this._fireAlarm) {
            if (PreshowClient.FIRE_ALARM_STATUS_FREQ != null) {
                if (PreshowClient.FIRE_ALARM_STATUS_FREQ.length == 2) {
                    this._fireAlarmStatusRepeater.start(FIRE_ALARM, Integer.parseInt(PreshowClient.FIRE_ALARM_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.FIRE_ALARM_STATUS_FREQ[1]));
                }
            }
        } else if (PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ != null) {
            if (PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ.length == 2) {
                this._fireAlarmStatusRepeater.start("fire_alarm_clear", Integer.parseInt(PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ[1]));
            }
        }
    }

    public void pauseReceivedFromCinemaServer() {
        System.out.println(PreshowClient.FAIL_SAFE_TIMER_DURATION + " " + this._failSafeTimer);
        if (PreshowClient.FAIL_SAFE_TIMER_DURATION > 0 && this._failSafeTimer == null) {
            this.startFailSafeTimer();
        }
    }

    @Override
    public void onInterProcessEvent(EventObject evt, byte[] source, String command, InterProcessArgument[] args) {
        System.out.println("Client Comm InterProcess Command " + command);
        System.out.println(PreshowClient.FAIL_SAFE_TIMER_DURATION + " " + this._preshowTimer);
        if (PreshowClient.FAIL_SAFE_TIMER_DURATION > 0 && this._preshowTimer == null) {
            this.startFailSafeTimer();
        }
    }

    @Override
    public void messageSendRequest(MessageEvent e) {
        try {
            this.send(e.getMessage());
            System.out.println(e.getMessage());
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
    }

    @Override
    public void fireAlarmActive(EventObject evt) {
        this.m_preshowFlag = false;
        if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ != null) {
            if (PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ.length == 2) {
                this._preshowClientStatusRepeater.start("preshow_inactive", Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.PRESHOW_INACTIVE_STATUS_FREQ[1]));
            }
        }
        if (this._preshowTimer != null) {
            this._preshowTimer.interrupt();
        }
        if (this._failSafeTimer != null) {
            this._failSafeTimer.interrupt();
        }
        if (PreshowClient.FIRE_ALARM_STATUS_FREQ != null) {
            if (PreshowClient.FIRE_ALARM_STATUS_FREQ.length == 2) {
                this._fireAlarmStatusRepeater.start(FIRE_ALARM, Integer.parseInt(PreshowClient.FIRE_ALARM_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.FIRE_ALARM_STATUS_FREQ[1]));
            }
        }
        this._fireAlarm = true;
    }

    @Override
    public void fireAlarmClear(EventObject evt) {
        if (PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ != null) {
            if (PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ.length == 2) {
                this._fireAlarmStatusRepeater.start("fire_alarm_clear", Integer.parseInt(PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ[0]), Integer.parseInt(PreshowClient.FIRE_ALARM_CLEAR_STATUS_FREQ[1]));
            }
        }
        this._fireAlarm = false;
    }
}

