/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.Logic;
import com.integpg.cinema.RegistryModifiedListener;
import com.integpg.cinema.client.PreshowClientHandler;
import com.integpg.cinema.client.PreshowClientTcpServer;
import com.integpg.cinema.client.PreshowStartMaskingMode;
import com.integpg.cinema.configuration.PreshowClientConfiguration;
import com.integpg.cinema.devices.TheatreDevice;
import com.integpg.comm.SerialPort;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.logger.FileLogger;
import com.integpg.serial.SerialHelper;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class PreshowClient
extends TheatreDevice
implements RegistryModifiedListener {
    public String REG_BASE = "AppData/Cinema/Client";
    public String REG_CLIENT_METHOD = this.REG_BASE + "/Method";
    public String REG_CLIENT_INCOMING_TERMINATION_STRING = this.REG_BASE + "/IncomingTerminationString";
    public String REG_CLIENT_OUTGOING_TERMINATION_STRING = this.REG_BASE + "/OutgoingTerminationString";
    public String REG_CLIENT_IO_ENABLED = this.REG_BASE + "/SerialCommandsEnabled";
    public String REG_CLIENT_UNSOLICITED_IO = this.REG_BASE + "/UnsolicitedIoAlerts";
    public String REG_CLIENT_SEND_COUNTS = this.REG_BASE + "/SendCounts";
    public String REG_CLIENT_SEND_ACK = this.REG_BASE + "/SendAck";
    public String REG_CLIENT_SEND_DATESTAMP = this.REG_BASE + "/SendDateStamp";
    public String REG_SERIAL = "AppData/Cinema/Serial";
    public static final int NCM = 0;
    public static final int BROADSIGN = 1;
    public int VENDOR = 0;
    public String REG_FAIL_SAFE_TIMER_DURATION = this.REG_BASE + "/FailSafeTimerDuration";
    public String REG_FAIL_SAFE_INPUT_TRIGGER = this.REG_BASE + "/FailSafeInputTrigger";
    private final String REG_FIVE_MIN_TIMER = "AppData/Cinema/FiveMinutePreshowTimerEnabled";
    private final String REG_PRESHOW_LAMP_OUTPUT = "AppData/Cinema/IO/PreshowLampOutput";
    private final String REG_MOVIE_STATUS_OUTPUT = "AppData/Cinema/IO/MovieStatusOutput";
    private final String REG_PRESHOW_LOCK_OUTPUT = "AppData/Cinema/IO/PreshowLockOutput";
    private final String REG_PRESHOW_START_PUSHBUTTON_INPUT = "AppData/Cinema/IO/PreshowStartPushButtonInput";
    private final String REG_FEATURE_START_INPUT = "AppData/Cinema/IO/FeatureStartInput";
    private static final String REG_PRESHOW_START_COMMAND = "AppData/Cinema/MACROS/PreshowStartCommand";
    private static final String REG_START_3D_COMMAND = "AppData/Cinema/MACROS/Start3dCommand";
    private static final String REG_PRESHOW_END_COMMAND = "AppData/Cinema/MACROS/PreshowEndCommand";
    private static final String REG_PRESHOW_START_MACRO = "AppData/Cinema/MACROS/PreshowStartMacro";
    private static final String REG_START_3D_MACRO = "AppData/Cinema/MACROS/Start3dMacro";
    private static final String REG_PRESHOW_END_MACRO = "AppData/Cinema/MACROS/PreshowEndMacro";
    private static final String REG_LAMP_RELAY_OPEN_MACRO = "AppData/Cinema/MACROS/LampRelayOpenMacro";
    public String CLIENT_METHOD = "disabled";
    public String CLIENT_INCOMING_TERMINATION_STRING = "\\r\\n";
    public byte[] CLIENT_INCOMING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_INCOMING_TERMINATION_STRING);
    public String CLIENT_OUTGOING_TERMINATION_STRING = "\\r\\n";
    public byte[] CLIENT_OUTGOING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_OUTGOING_TERMINATION_STRING);
    public boolean CLIENT_IO_ENABLED = false;
    public boolean CLIENT_UNSOLICITED_IO = false;
    public boolean CLIENT_SEND_COUNTS = false;
    public boolean CLIENT_SEND_ACK = true;
    public boolean CLIENT_SEND_DATESTAMP = true;
    public static String CLIENT_LOG = "cinema_client.log";
    public static String[] MOVIE_OFF_STATUS_FREQ = null;
    public static String[] MOVIE_ON_STATUS_FREQ = null;
    public static String[] PRESHOW_INACTIVE_STATUS_FREQ = null;
    public static String[] PRESHOW_ACTIVE_STATUS_FREQ = null;
    public static String[] FIRE_ALARM_STATUS_FREQ = null;
    public static String[] FIRE_ALARM_CLEAR_STATUS_FREQ = null;
    public static int FAIL_SAFE_TIMER_DURATION = -1;
    public static int FAIL_SAFE_INPUT_TRIGGER = -1;
    public static boolean FIVE_MIN_TIMER = false;
    public static int PRESHOW_LAMP_OUTPUT = -1;
    public static int MOVIE_STATUS_OUTPUT = -1;
    public static int PRESHOW_LOCK_OUTPUT = -1;
    public static int PRESHOW_START_PUSHBUTTON_INPUT = -1;
    public static int FEATURE_START_INPUT = -1;
    public String PRESHOW_START_MACRO = "Preshow Start";
    public String PRESHOW_START_SUCCESS_RESPONSE = "start_preshow_executed";
    public String PRESHOW_START_FAILED_RESPONSE = "start_preshow_failed";
    public String START_3D_MACRO = "Preshow 3D";
    public String START_3D_SUCCESS_RESPONSE = "start_preshow_executed";
    public String START_3D_FAILED_RESPONSE = "start_preshow_failed";
    public String PRESHOW_END_MACRO = "Preshow End";
    public String PRESHOW_END_SUCCESS_RESPONSE = "end_preshow_executed_sms_play";
    public String PRESHOW_END_FAILED_RESPONSE = "end_preshow_failed";
    public String PRESHOW_END_ABORTED_RESPONSE = "end_preshow_DC_start";
    public String LAMP_RELAY_OPEN_MACRO = "Lamp Off";
    public boolean ALLOW_QUERY = false;
    public boolean PUSH_BOTTON_EXECUTE_MACROS = true;
    public String START_PRESHOW_TEST_MACRO = "Preshow Start";
    public String END_PRESHOW_TEST_MACRO = "Preshow End";
    public int PUSH_BUTTON_DEBOUNCE_TIME = 45;
    public int PUSH_BUTTON_FAIL_SAFE_DURATION = 10;
    private SerialPort _serial;
    private InputStream in;
    private OutputStream out;
    private Thread m_serialThread;
    private PreshowClientHandler m_serialHandler = null;
    private String _serialPortName;
    PreshowClientTcpServer _tcpServer = null;
    public static boolean CLIENT_USE_LOG;
    public static Hashtable _logicRulesByCommand;

    public PreshowClient() {
        super("Preshow_Client");
        super.setHost("0.0.0.0");
        PreshowStartMaskingMode.init();
    }

    public int getServerPort() {
        return this._tcpServer.getPort();
    }

    public String getSerialPort() {
        return this._serialPortName;
    }

    public void start() {
        int tcpPort;
        SerialHelper.getConfiguration(this.REG_SERIAL, "AUX");
        if (this.CLIENT_METHOD.toLowerCase().equals("serial")) {
            try {
                this._serialPortName = RegistryUtils.getRegistryKey(this.REG_SERIAL + "/SerialPort", "AUX");
                this._serial = SerialHelper.getSerialPort(this.REG_SERIAL, "AUX");
                System.out.println(this._serial);
            }
            catch (Exception ex) {
                FileLogger.error(ex);
                return;
            }
            try {
                this.in = this._serial.getInputStream();
                this.out = this._serial.getOutputStream();
            }
            catch (IOException ex) {
                FileLogger.error(ex);
            }
            this.m_serialHandler = new PreshowClientHandler(this, this.in, this.out);
            this.m_serialThread = new Thread((Runnable)this.m_serialHandler, "PreshowClient Serial Handler");
            this.m_serialThread.setDaemon(true);
            this.m_serialThread.start();
            try {
                CinemaMain.ProtocolCommandMonitor.setLocalHook("90SecondTimer", this.m_serialHandler);
                FileLogger.info("Register InterProcess 90 Second Timer Command");
            }
            catch (Exception ex) {
                FileLogger.error(ex);
            }
        }
        if (0 < (tcpPort = PreshowClientConfiguration.getTcpPort())) {
            FileLogger.info("Start Tcp Server:" + tcpPort);
            this._tcpServer = new PreshowClientTcpServer(this, tcpPort);
        }
    }

    public void getConfig() {
        FileLogger.info("Getting Preshow Client Configuration");
        this.CLIENT_METHOD = RegistryUtils.getRegistryKey(this.REG_CLIENT_METHOD, this.CLIENT_METHOD);
        String terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_INCOMING_TERMINATION_STRING, (String)"");
        if (terminationString.equals("")) {
            terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_INCOMING_TERMINATION_STRING, (String)this.CLIENT_INCOMING_TERMINATION_STRING);
        }
        CLIENT_USE_LOG = RegistryUtils.getRegistryKey("AppData/Cinema/Logs/ClientLog", true);
        this.CLIENT_INCOMING_TERMINATION_STRING = RegistryUtils.getRegistryKey(this.REG_CLIENT_INCOMING_TERMINATION_STRING, terminationString);
        this.CLIENT_INCOMING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_INCOMING_TERMINATION_STRING);
        this.CLIENT_INCOMING_TERMINATION_STRING = new String(this.CLIENT_INCOMING_TERMINATION_BYTES);
        terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_OUTGOING_TERMINATION_STRING, (String)"");
        if (terminationString.equals("")) {
            terminationString = JANOS.getRegistryString((String)this.REG_CLIENT_OUTGOING_TERMINATION_STRING, (String)this.CLIENT_OUTGOING_TERMINATION_STRING);
        }
        this.CLIENT_OUTGOING_TERMINATION_STRING = RegistryUtils.getRegistryKey(this.REG_CLIENT_OUTGOING_TERMINATION_STRING, terminationString);
        if (!this.CLIENT_OUTGOING_TERMINATION_STRING.equalsIgnoreCase("none")) {
            this.CLIENT_OUTGOING_TERMINATION_BYTES = this.getTerminationBytes(this.CLIENT_OUTGOING_TERMINATION_STRING);
            this.CLIENT_OUTGOING_TERMINATION_STRING = new String(this.CLIENT_OUTGOING_TERMINATION_BYTES);
        } else {
            this.CLIENT_OUTGOING_TERMINATION_BYTES = new byte[0];
            this.CLIENT_OUTGOING_TERMINATION_STRING = "";
        }
        this.CLIENT_IO_ENABLED = RegistryUtils.getRegistryKey(this.REG_CLIENT_IO_ENABLED, this.CLIENT_IO_ENABLED);
        this.CLIENT_UNSOLICITED_IO = RegistryUtils.getRegistryKey(this.REG_CLIENT_UNSOLICITED_IO, this.CLIENT_UNSOLICITED_IO);
        this.CLIENT_SEND_COUNTS = RegistryUtils.getRegistryKey(this.REG_CLIENT_SEND_COUNTS, this.CLIENT_SEND_COUNTS);
        this.CLIENT_SEND_ACK = RegistryUtils.getRegistryKey(this.REG_CLIENT_SEND_ACK, this.CLIENT_SEND_ACK);
        this.CLIENT_SEND_DATESTAMP = RegistryUtils.getRegistryKey(this.REG_CLIENT_SEND_DATESTAMP, this.CLIENT_SEND_DATESTAMP);
        FAIL_SAFE_TIMER_DURATION = RegistryUtils.getRegistryKey(this.REG_FAIL_SAFE_TIMER_DURATION, FAIL_SAFE_TIMER_DURATION);
        FAIL_SAFE_INPUT_TRIGGER = RegistryUtils.getRegistryKey(this.REG_FAIL_SAFE_INPUT_TRIGGER, FAIL_SAFE_INPUT_TRIGGER);
        FIVE_MIN_TIMER = RegistryUtils.getRegistryKey("AppData/Cinema/FiveMinutePreshowTimerEnabled", FIVE_MIN_TIMER);
        PRESHOW_LAMP_OUTPUT = RegistryUtils.getRegistryKey("AppData/Cinema/IO/PreshowLampOutput", PRESHOW_LAMP_OUTPUT);
        MOVIE_STATUS_OUTPUT = RegistryUtils.getRegistryKey("AppData/Cinema/IO/MovieStatusOutput", MOVIE_STATUS_OUTPUT);
        PRESHOW_LOCK_OUTPUT = RegistryUtils.getRegistryKey("AppData/Cinema/IO/PreshowLockOutput", PRESHOW_LOCK_OUTPUT);
        PRESHOW_START_PUSHBUTTON_INPUT = RegistryUtils.getRegistryKey("AppData/Cinema/IO/PreshowStartPushButtonInput", PRESHOW_START_PUSHBUTTON_INPUT);
        FEATURE_START_INPUT = RegistryUtils.getRegistryKey("AppData/Cinema/IO/FeatureStartInput", FEATURE_START_INPUT);
        PreshowClientHandler.START_PRESHOW_COMMAND = RegistryUtils.getRegistryKey(REG_PRESHOW_START_COMMAND, PreshowClientHandler.START_PRESHOW_COMMAND);
        PreshowClientHandler.START_3D = RegistryUtils.getRegistryKey(REG_START_3D_COMMAND, PreshowClientHandler.START_3D);
        PreshowClientHandler.END_PRESHOW = RegistryUtils.getRegistryKey(REG_PRESHOW_END_COMMAND, PreshowClientHandler.END_PRESHOW);
        this.PRESHOW_START_MACRO = RegistryUtils.getRegistryKey(REG_PRESHOW_START_MACRO, this.PRESHOW_START_MACRO);
        this.START_3D_MACRO = RegistryUtils.getRegistryKey(REG_START_3D_MACRO, this.START_3D_MACRO);
        this.PRESHOW_END_MACRO = RegistryUtils.getRegistryKey(REG_PRESHOW_END_MACRO, this.PRESHOW_END_MACRO);
        this.LAMP_RELAY_OPEN_MACRO = RegistryUtils.getRegistryKey(REG_LAMP_RELAY_OPEN_MACRO, this.LAMP_RELAY_OPEN_MACRO);
        PreshowClient.getMidPreshowMacro();
        this.getTimerConfig();
        this.ALLOW_QUERY = RegistryUtils.getRegistryKey("AppData/Cinema/Client/Query", this.ALLOW_QUERY);
        this.PRESHOW_START_SUCCESS_RESPONSE = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowStartSuccessResponse", this.PRESHOW_START_SUCCESS_RESPONSE);
        this.PRESHOW_START_FAILED_RESPONSE = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowStartFailedResponse", this.PRESHOW_START_FAILED_RESPONSE);
        this.START_3D_SUCCESS_RESPONSE = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/Start3dSuccessResponse", this.START_3D_SUCCESS_RESPONSE);
        this.START_3D_FAILED_RESPONSE = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/Start3dFailedResponse", this.START_3D_FAILED_RESPONSE);
        this.PRESHOW_END_SUCCESS_RESPONSE = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowEndSuccessResponse", this.PRESHOW_END_SUCCESS_RESPONSE);
        this.PRESHOW_END_FAILED_RESPONSE = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowEndFailedResponse", this.PRESHOW_END_FAILED_RESPONSE);
        this.PUSH_BOTTON_EXECUTE_MACROS = RegistryUtils.getRegistryKey("AppData/Cinema/Client/PushButtonMacroExecute", this.PUSH_BOTTON_EXECUTE_MACROS);
        this.START_PRESHOW_TEST_MACRO = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowStartTest", this.START_PRESHOW_TEST_MACRO);
        this.END_PRESHOW_TEST_MACRO = RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowEndTest", this.END_PRESHOW_TEST_MACRO);
        this.PUSH_BUTTON_DEBOUNCE_TIME = RegistryUtils.getRegistryKey("AppData/Cinema/Client/PushButtonDebounceDuration", this.PUSH_BUTTON_DEBOUNCE_TIME);
        this.PUSH_BUTTON_FAIL_SAFE_DURATION = RegistryUtils.getRegistryKey("AppData/Cinema/Client/PushButtonFailSafeDuration", this.PUSH_BUTTON_FAIL_SAFE_DURATION);
        this.VENDOR = RegistryUtils.getRegistryKey("AppData/Cinema/Client/Vendor", 0);
    }

    protected static String getMidPreshowMacro() {
        return RegistryUtils.getRegistryKey("AppData/Cinema/MACROS/PreshowMidMacro", "none");
    }

    public void getTimerConfig() {
        MOVIE_OFF_STATUS_FREQ = RegistryUtils.getRegistryKeys("AppData/Cinema/Client/Timers/MovieOffStatusFrequency", "none");
        MOVIE_ON_STATUS_FREQ = RegistryUtils.getRegistryKeys("AppData/Cinema/Client/Timers/MovieOnStatusFrequency", "none");
        PRESHOW_INACTIVE_STATUS_FREQ = RegistryUtils.getRegistryKeys("AppData/Cinema/Client/Timers/PreshowInactiveStatusFrequency", "none");
        PRESHOW_ACTIVE_STATUS_FREQ = RegistryUtils.getRegistryKeys("AppData/Cinema/Client/Timers/PreshowActiveStatusFrequency", "none");
        FIRE_ALARM_STATUS_FREQ = RegistryUtils.getRegistryKeys("AppData/Cinema/Client/Timers/FireAlarmStatusFrequency", "none");
        FIRE_ALARM_CLEAR_STATUS_FREQ = RegistryUtils.getRegistryKeys("AppData/Cinema/Client/Timers/FireAlarmClearStatusFrequency", "none");
    }

    protected byte[] getTerminationBytes(String terminationString) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < terminationString.length(); ++i) {
            if (terminationString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (terminationString.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                    }
                }
            } else {
                newTermString = newTermString + terminationString.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString.getBytes();
    }

    public void stop() {
        if (this._tcpServer != null) {
            try {
                this._tcpServer.stop();
            }
            catch (IOException ex) {
                FileLogger.error(ex);
            }
        }
    }

    public void send(String message) throws IOException {
        if (this.m_serialHandler != null) {
            this.m_serialHandler.send(message);
        }
        if (this._tcpServer != null) {
            this._tcpServer.send(message);
        }
    }

    public void pauseReceivedFromCinemaServer() {
        if (this.m_serialHandler != null) {
            this.m_serialHandler.pauseReceivedFromCinemaServer();
        }
        if (this._tcpServer != null) {
            this._tcpServer.pauseReceivedFromCinemaServer();
        }
    }

    @Override
    public synchronized boolean macroExecute(String macroName) {
        System.out.println("Preshow Client Macro Execute");
        String lower = macroName.toLowerCase();
        if (lower.startsWith("send")) {
            String send = macroName.substring(5);
            String data = null;
            String converted = this.convertHexToString(send);
            data = converted != null ? converted : send;
            if (data == null) {
                FileLogger.info(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            byte[] dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            FileLogger.info(Config.DEVICES_LOG, this.name + " Executing Macro - " + macroName);
            try {
                this.send(new String(dataBytes));
            }
            catch (IOException ex) {
                FileLogger.error(ex);
            }
        }
        return true;
    }

    @Override
    public void registryModified(String key) {
        System.out.println("Key Modified " + key);
        if (key.startsWith("AppData/Cinema/Client/Timers")) {
            this.getTimerConfig();
            if (this.m_serialHandler != null) {
                this.m_serialHandler.timerConfigUpdated();
            }
            if (this._tcpServer != null) {
                this._tcpServer.pauseReceivedFromCinemaServer();
            }
        }
    }

    public void addLogic(String command, Logic logic) {
        _logicRulesByCommand.put(command, logic);
    }

    static {
        _logicRulesByCommand = new Hashtable();
        PreshowClientConfiguration.init();
    }
}

