/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logging;

import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class Logger
extends PrintStream {
    private static final QuickDateFormat QUICK_DATE_FORMAT = QuickDateFormat.getDefault();
    private static final String LOG_FORMAT = "%s, %s\r\n";
    private static final int[] VersionNumbers = JANOS.getVersionNum();
    private String _filename = null;
    private File _file = null;
    private File _bakFile = null;
    private boolean _firstEntry = true;
    private int _maxSize = 65536;

    public static Logger getLogger() {
        return new Logger();
    }

    public static Logger getLogger(String filename) {
        try {
            return new Logger(filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Logger();
        }
    }

    private Logger() {
        super(System.out);
    }

    private Logger(String filename) throws FileNotFoundException, IOException {
        super(System.out);
        if (null != filename) {
            this._filename = filename;
            this._file = new File(filename);
            this._bakFile = new File(filename + ".bak");
        }
    }

    public Logger setMaxSizeKB(int maxSizeKb) {
        this._maxSize = maxSizeKb * 1024;
        return this;
    }

    public void vital(Object object) {
        this.println(String.format("## %s", String.valueOf(object)));
    }

    public void debug(Object object) {
        this.println(String.format("?? %s", String.valueOf(object)));
    }

    public void info(Object object) {
        this.println(object);
    }

    public void warn(Object object) {
        this.println(String.format(" * %s", String.valueOf(object)));
    }

    public void error(Object object) {
        this.println(String.format("** %s", String.valueOf(object)));
    }

    public void error(Exception ex) {
        String stackTrace = Logger.getStackTrace(ex);
        this.println(String.format("** %s", stackTrace));
    }

    public void error(Object object, Throwable ex) {
        String stackTrace = Logger.getStackTrace(ex);
        this.println(String.format("** %s: %s", object, stackTrace));
    }

    public static String getStackTrace(Throwable ex) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        ex.printStackTrace(printStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(char c) {
        this.println(String.valueOf(c));
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(int i) {
        this.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    @Override
    public void println(boolean flag) {
        this.println(String.valueOf(flag));
    }

    @Override
    public void println(char[] ac) {
        this.println(String.valueOf(ac));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String message) {
        if (null == this._filename) {
            super.println(message);
        } else {
            if (this._firstEntry) {
                this._firstEntry = false;
                this.println("--------------------------------------------------");
            }
            super.println(String.format("[%s]: %s", this._filename, message));
            if (2 <= VersionNumbers[0] && 65536 == this._maxSize) {
                JANOS.logfile((String)this._filename, (String)message);
            } else {
                message = String.format(LOG_FORMAT, QUICK_DATE_FORMAT.format(System.currentTimeMillis()), message);
                long newSize = this._file.length() + (long)message.length();
                if (this._file != null && newSize > (long)this._maxSize) {
                    if (this._bakFile.exists()) {
                        this._bakFile.delete();
                    }
                    this._file.renameTo(this._bakFile);
                }
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(this._filename, "rw");
                    raf.seek(raf.length());
                    raf.write(message.getBytes(), 0, message.length());
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    if (null != raf) {
                        try {
                            raf.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void write(int i) {
        throw new RuntimeException();
    }

    @Override
    public void write(byte[] abyte0, int i, int j) {
        throw new RuntimeException();
    }
}

