/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class RawSerial
extends TheatreSerialDevice {
    public RawSerial(String name) {
        super(name);
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        try {
            String newTermString = "";
            boolean backslashFound = false;
            if (this.terminationString != null) {
                for (int i = 0; i < this.terminationString.length(); ++i) {
                    if (this.terminationString.charAt(i) == '\\' && !backslashFound) {
                        backslashFound = true;
                        continue;
                    }
                    if (backslashFound) {
                        switch (this.terminationString.charAt(i)) {
                            case 'r': {
                                newTermString = newTermString + '\r';
                                break;
                            }
                            case 'n': {
                                newTermString = newTermString + '\n';
                                break;
                            }
                            case 't': {
                                newTermString = newTermString + '\t';
                                break;
                            }
                            case 'f': {
                                newTermString = newTermString + '\f';
                                break;
                            }
                            case 'b': {
                                newTermString = newTermString + '\b';
                                break;
                            }
                            case '0': {
                                newTermString = newTermString + '\u0000';
                            }
                        }
                    } else {
                        newTermString = newTermString + this.terminationString.charAt(i);
                    }
                    backslashFound = false;
                }
            }
            if (commandName.startsWith("send")) {
                return super.doSend(commandName);
            }
        }
        catch (RuntimeException ex) {
            FileLogger.error("Cinema.jnior: Raw Serial Execute Macro Too Many Threads.", ex);
        }
        return true;
    }

    @Override
    public boolean send(byte[] bytes) {
        if (this.serial == null) {
            this.ensureConnection();
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
            } else {
                System.out.println("output stream is null");
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
        return true;
    }

    @Override
    public boolean login() {
        return false;
    }
}

