App.controller('logic', ['$scope', function ($scope) {

    var _this = this;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log("logic on load called")
        _this.config = {
            logic: []
        }
        _this.savedConfig;
        _this.Version;
        jnrwebsocket.getRegistryListing('AppData/Cinema/Logic', function (registryKey, registryValues) {
            var values = [];
            values = registryValues;
            jnrwebsocket.readRegistryKeys(values, function (registryKey, registryValue) {
                _this.config.logic.push({ regname: registryKey, output: registryValue });
                _this.savedConfig = angular.copy(_this.config);
                $scope.$apply();
            });
        })

    });

    _this.addLogic = function () {
        var newRule = prompt("Enter the name of the new logic rule");
        if (newRule == "") {
            alert("A name for the new registry key is required.");
            _this.addLogic();
        }
        else if (!/^[0-9a-zA-Z_]+$/.test(newRule)) {
            alert("Registry name may only contatin letters, numbers, and underscores.")
            _this.addLogic();
        }
        else if (newRule != null) {
            _this.config.logic.push({ regname: 'AppData/Cinema/Logic/' + newRule, output: 'none' });
        }
    };

    _this.removeLogic = function (reg) {
        index = _this.config.logic.indexOf(reg);
        _this.config.logic[index].output = "";
    };
    
    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(_this.config, _this.savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        angular.forEach(_this.config.logic, function (value, key) {
            jnrwebsocket.registryWrite(value.regname, value.output)
        })
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    };

}]);