/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Config;
import com.integpg.cinema.Logic;
import com.integpg.cinema.Monitor.IOStateListener;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.externalio.TypeFB;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application2;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Vector;

public class CinemaIO
implements IOStateListener,
MacroRequestListener {
    protected static final Logger LOG = Logger.getLogger("temp/" + Application2.getAppName() + "_iologmonitor.log");
    private static int m_preshowLock = -1;
    private static int m_preshowLamp = -1;
    private int m_lastInputStates = 0;
    private int m_lastOutputStates = 0;
    private boolean m_quit = false;
    private Thread m_preshowLockThread = null;
    private Vector[] _inputLogicRules = new Vector[12];
    private Vector[] _outputLogicRules = new Vector[16];
    private Thread[] _delayedInputTriggerThreads = new Thread[12];

    public CinemaIO() {
        try {
            this.m_lastInputStates = this.assignInputStates(JANOS.getInputStates());
            this.m_lastOutputStates = this.assignOutputStates(JANOS.getOutputStates(), 65535);
            for (int channel = 1; channel <= 8; ++channel) {
                int state = this.m_lastInputStates >> channel - 1 & 1;
                this.doSlavingForInput(channel, state);
            }
            this.getInputStates();
            this.getOutputStates();
            int outputCount = UnitConfig.getOutputCount();
            int internalOutputCount = UnitConfig.getInternalOutputCount();
            if (16 < outputCount) {
                int internalModuleCount = (16 - internalOutputCount) / 4;
                System.out.println("internalModuleCount = " + internalModuleCount);
                int externalModuleCount = (outputCount - 16) / 4;
                System.out.println("moduleCount = " + externalModuleCount);
                for (int i = 0; i < externalModuleCount; ++i) {
                    final int moduleIndex = i + internalModuleCount;
                    final TypeFB fb = TypeFB.getByIndex(moduleIndex);
                    System.out.println("fb = " + fb);
                    final int startingInput = 16 + i * 4;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.currentThread().setName("monitor external 4rout: " + fb.AddressString);
                                int savedOutputsMask = 0;
                                try {
                                    fb.read();
                                    savedOutputsMask = fb.getOutputs();
                                    System.out.println(String.format("%d: %04x", moduleIndex, savedOutputsMask));
                                }
                                catch (IOException ex) {
                                    FileLogger.error("error reading " + fb.AddressString, ex);
                                }
                                while (true) {
                                    Thread.sleep(2000L);
                                    try {
                                        fb.read();
                                        int outputsMask = fb.getOutputs();
                                        if (outputsMask == savedOutputsMask) continue;
                                        int changedMask = outputsMask ^ savedOutputsMask;
                                        for (int j = 0; j < 4 && changedMask != 0; ++j, changedMask >>= 1) {
                                            if ((changedMask & 1) != 1) continue;
                                            int channel = startingInput + j + 1;
                                            int state = outputsMask >> j & 1;
                                            CinemaIO.this.ioStateChange(1, (byte)channel, (byte)state, 0L, outputsMask);
                                        }
                                        savedOutputsMask = outputsMask;
                                    }
                                    catch (IOException ex) {
                                        FileLogger.error("error reading " + fb.AddressString, ex);
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                    }).start();
                }
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
    }

    public void monitorPreshowLock() {
        if (Config.PRESHOW_LOCK_OUTPUT != -1) {
            this.m_preshowLockThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int cnt = 5;
                    while (!CinemaIO.this.m_quit) {
                        try {
                            Thread.sleep(5000L);
                            if (cnt-- != 0) continue;
                            cnt = 5;
                        }
                        catch (InterruptedException ex) {
                            FileLogger.error(ex);
                        }
                        try {
                            CinemaIO.this.getOutputStates();
                        }
                        catch (IOException ex) {
                            FileLogger.error(ex);
                        }
                    }
                }
            }, "Monitor Preshow Lock");
            this.m_preshowLockThread.setDaemon(true);
            this.m_preshowLockThread.start();
        }
    }

    public void stop() {
        this.m_quit = true;
    }

    public void setOutputStates(long data, long mask) throws IOException {
        this.assignOutputStates((int)data, (int)mask);
        if (0L != (mask & 0xFFFFL)) {
            JANOS.setOutputStates((int)((int)data), (int)((int)mask));
        }
        mask &= 0xFFFF0000L;
        data &= 0xFFFF0000L;
        data >>= 16;
        if (0L != (mask >>= 16)) {
            int moduleIndex;
            TypeFB[] relayOutputModules = TypeFB.getDeviceArray();
            int internalOutputCount = UnitConfig.getInternalOutputCount();
            System.out.println(String.format("relayOutputModules.length: %d, internalOutputCount: %d, moduleIndex: %d", relayOutputModules.length, internalOutputCount, moduleIndex));
            for (moduleIndex = 4 - internalOutputCount / 4; 0L != mask && moduleIndex < relayOutputModules.length; ++moduleIndex) {
                System.out.println(String.format("4rout_%d setOutputStates(%s, %s)", moduleIndex, Long.toHexString(data & 0xFL), Long.toHexString(mask & 0xFL)));
                relayOutputModules[moduleIndex].setOutputs((int)data & 0xF, (int)mask & 0xF);
                mask >>= 4;
                data >>= 4;
            }
        }
    }

    public void setOutputPulsed(long data, long mask, int duration) throws IOException {
        System.out.println("debug: cinemaio.setoutputpulsed " + data + " " + mask);
        this.assignOutputStates((int)data, (int)mask);
        if (0L != (mask & 0xFFFFL)) {
            JANOS.setOutputPulsed((int)((int)data), (int)((int)mask), (int)duration);
        }
        mask &= 0xFFFF0000L;
        data &= 0xFFFF0000L;
        System.out.println("debug: cinemaio.setoutputpulsed " + (data >>= 16) + " " + (mask >>= 16));
        if (0L != mask) {
            int moduleIndex;
            TypeFB[] relayOutputModules = TypeFB.getDeviceArray();
            int internalOutputCount = UnitConfig.getInternalOutputCount();
            System.out.println(String.format("relayOutputModules.length: %d, internalOutputCount: %d, moduleIndex: %d", relayOutputModules.length, internalOutputCount, moduleIndex));
            for (moduleIndex = 4 - internalOutputCount / 4; 0L != mask && moduleIndex < relayOutputModules.length; ++moduleIndex) {
                System.out.println(Long.toHexString(mask));
                System.out.println(String.format("4rout_%d setOutputStates(%s, %s)", moduleIndex, Long.toHexString(data & 0xFL), Long.toHexString(mask & 0xFL)));
                relayOutputModules[moduleIndex].pulseOutputs((int)data & 0xF, (int)mask & 0xF, duration);
                mask >>= 4;
                data >>= 4;
            }
        }
    }

    public long getInputStates() throws IOException {
        return this.assignInputStates(JANOS.getInputStates());
    }

    public long getOutputStates() throws IOException {
        return this.assignOutputStates(JANOS.getOutputStates(), 65535);
    }

    private synchronized int assignInputStates(int states) {
        this.m_lastInputStates = states;
        return states;
    }

    private int assignOutputStates(int data, int mask) {
        int states = data;
        int changes = (states ^ this.m_lastOutputStates) & mask;
        for (int channel = 1; channel <= 16; ++channel) {
            if ((mask & 1) != 0) {
                int state = data & 1;
                if (Config.PRESHOW_LOCK_OUTPUT != -1 && channel == Config.PRESHOW_LOCK_OUTPUT) {
                    CinemaIO.setPreshowLock(state);
                } else if (channel != Config.MOVIE_STATUS_OUTPUT && channel == Config.PRESHOW_LAMP_OUTPUT && state != m_preshowLamp) {
                    m_preshowLamp = state;
                }
            }
            changes >>= 1;
            mask >>= 1;
            data >>= 1;
        }
        this.m_lastOutputStates = states;
        return states;
    }

    public static void setPreshowLock(int state) {
        if (Config.PRESHOW_LOCK_INVERT) {
            state = (state + 1) % 2;
        }
        if (state != m_preshowLock) {
            m_preshowLock = state;
            if (Config.MOVIE_STATUS_OUTPUT != -1) {
                try {
                    JANOS.setOutputStates((int)(~m_preshowLock << Config.MOVIE_STATUS_OUTPUT - 1), (int)(1 << Config.MOVIE_STATUS_OUTPUT - 1));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static int getPreshowLock() {
        return m_preshowLock;
    }

    public static int getMovieStatus() {
        return m_preshowLock;
    }

    public static void setPreshowLamp(int state) {
        m_preshowLamp = state;
    }

    public static int getPreshowLamp() {
        return m_preshowLamp;
    }

    public void doSlavingForInput(int channel, int state) {
        for (int output = 0; output < 16; ++output) {
            try {
                if (Config.SLAVED_IO[output] == channel) {
                    this.setOutputStates(state << output, 1 << output);
                    continue;
                }
                if (Config.SLAVED_IO[output] != -channel) continue;
                this.setOutputStates((state + 1) % 2 << output, 1 << output);
                continue;
            }
            catch (IOException ex) {
                FileLogger.error("Error performing slaving on output " + (output + 1), ex);
            }
        }
    }

    @Override
    public void ioStateChange(int io, byte channel, byte state, final long inputStateMask, final long outputStateMask) {
        block18: {
            System.out.println(String.format("inputStateMask: %lld", System.currentTimeMillis()));
            final long triggerTime = System.currentTimeMillis();
            FileLogger.info((0 == io ? "Input" : "Output") + " Trigger IO Change on channel " + channel + ":" + state);
            switch (io) {
                case 0: {
                    if (this._inputLogicRules[channel - 1] == null) break;
                    int logicRuleCount = this._inputLogicRules[channel - 1].size();
                    for (int i = 0; i < logicRuleCount; ++i) {
                        final Logic logic = (Logic)this._inputLogicRules[channel - 1].elementAt(i);
                        ThreadPool.execute(new Runnable(){

                            @Override
                            public void run() {
                                int result = logic.evaluate(inputStateMask, outputStateMask, triggerTime);
                                if (result == 1) {
                                    logic.execute();
                                }
                            }
                        });
                    }
                    break;
                }
                case 1: {
                    if (channel >= this._outputLogicRules.length || this._outputLogicRules[channel - 1] == null) break;
                    int logicRuleCount = this._outputLogicRules[channel - 1].size();
                    for (int i = 0; i < logicRuleCount; ++i) {
                        final Logic logic = (Logic)this._outputLogicRules[channel - 1].elementAt(i);
                        ThreadPool.execute(new Runnable(){

                            @Override
                            public void run() {
                                int result = logic.evaluate(inputStateMask, outputStateMask, triggerTime);
                                if (result == 1) {
                                    logic.execute();
                                }
                            }
                        });
                    }
                    break;
                }
            }
            if (Config.CLIENT_UNSOLICITED_IO && CinemaMain.INSTANCE.clientComm != null) {
                if (io == 0) {
                    try {
                        if (Config.CLIENT_SEND_COUNTS) {
                            int count = JANOS.getInputCounter((int)(channel - 1));
                            CinemaMain.INSTANCE.clientComm.send("IN" + channel + "=" + state + "," + count);
                            break block18;
                        }
                        CinemaMain.INSTANCE.clientComm.send("IN" + channel + "=" + state);
                    }
                    catch (IOException ex) {
                        FileLogger.error(ex);
                    }
                } else {
                    if (Config.CLIENT_UNSOLICITED_IO && CinemaMain.INSTANCE.clientComm != null) {
                        try {
                            CinemaMain.INSTANCE.clientComm.send("OUT" + channel + "=" + state);
                        }
                        catch (IOException ex) {
                            FileLogger.error(ex);
                        }
                    }
                    this.m_lastOutputStates = state == 0 ? (this.m_lastOutputStates &= 0xFFFF ^ 1 << channel - 1) : (this.m_lastOutputStates |= 1 << channel - 1);
                }
            }
        }
        if (io == 0) {
            this.doSlavingForInput(channel, state);
            this.checkInputTriggerMacros(channel, state);
        } else if (io == 1) {
            this.checkOutputTriggerMacros(channel, state);
        }
    }

    private void checkForDelayedTrigger(int channel) {
        try {
            System.out.println("Start timer to check for delayed trigger?");
            Thread.sleep(Config.INPUT_TRIGGER_DELAY_TIMES[channel]);
            int state = JANOS.getInputStates() >> channel & 1;
            System.out.println("Is delayed trigger input still high? " + state);
            if (state == 1) {
                MacroExecuter.runMacro(this, Config.INPUT_TRIGGER_MACROS[channel]);
            }
        }
        catch (Exception ex) {
            System.out.println("Delayed trigger trimer interrupted");
        }
        this._delayedInputTriggerThreads[channel] = null;
    }

    private void checkInputTriggerMacros(final int channel, int state) {
        LOG.info(String.format("checkInputTriggerMacros: %lld", System.currentTimeMillis()));
        try {
            if (channel <= Config.INPUT_TRIGGER_MACROS.length && Config.INPUT_TRIGGER_MACROS[channel - 1] != null && !Config.INPUT_TRIGGER_MACROS[channel - 1].equals("none") && state == 1) {
                if (Config.INPUT_TRIGGER_DELAY_TIMES[channel - 1] > 0) {
                    System.out.println(String.format("INPUT_TRIGGER_DELAY_TIMES: %lld", System.currentTimeMillis()));
                    if (this._delayedInputTriggerThreads[channel - 1] == null) {
                        this._delayedInputTriggerThreads[channel - 1] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                CinemaIO.this.checkForDelayedTrigger(channel - 1);
                            }
                        });
                        this._delayedInputTriggerThreads[channel - 1].setDaemon(true);
                        this._delayedInputTriggerThreads[channel - 1].start();
                    }
                } else {
                    System.out.println(String.format("no INPUT_TRIGGER_DELAY_TIMES: %lld", System.currentTimeMillis()));
                    MacroExecuter.runMacros(this, Config.INPUT_TRIGGER_MACROS[channel - 1]);
                }
            }
        }
        catch (Exception ex) {
            FileLogger.error("error checking output triggers", ex);
        }
    }

    private void checkOutputTriggerMacros(int channel, int state) {
        try {
            if (channel <= Config.OUTPUT_TRIGGER_MACROS.length && Config.OUTPUT_TRIGGER_MACROS[channel - 1] != null && !Config.OUTPUT_TRIGGER_MACROS[channel - 1].equals("none") && state == 1) {
                MacroExecuter.runMacros(this, Config.OUTPUT_TRIGGER_MACROS[channel - 1]);
            }
        }
        catch (Exception ex) {
            FileLogger.error("error checking output triggers", ex);
        }
    }

    public void macroResponse(String response, boolean success) {
        FileLogger.info("Input Trigger " + response);
    }

    void addLogic(Logic logic) {
        int channel = 0;
        int inputsUsedMask = logic.getInputsUsedMask();
        while (inputsUsedMask != 0) {
            if ((inputsUsedMask & 1) != 0) {
                if (this._inputLogicRules[channel] == null) {
                    this._inputLogicRules[channel] = new Vector();
                }
                this._inputLogicRules[channel].addElement(logic);
            }
            inputsUsedMask >>= 1;
            ++channel;
        }
        channel = 0;
        int outputsUsedMask = logic.getOutputsUsedMask();
        while (outputsUsedMask != 0) {
            if ((outputsUsedMask & 1) != 0) {
                if (this._outputLogicRules[channel] == null) {
                    this._outputLogicRules[channel] = new Vector();
                    CinemaMain.INSTANCE._stateMonitor.addStateListener(this, 1, channel + 1);
                }
                this._outputLogicRules[channel].addElement(logic);
            }
            outputsUsedMask >>= 1;
            ++channel;
        }
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }
}

