App.controller('cinemaserverclient', ['$scope', function ($scope) {

    var _this = this;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log("cinemaserverclient on load called")
        _this.config = {
            cinemaServerClientSettings: {
                incomingTerminationString: "\\n", outgoingTerminationString: "\\n", /**"pauseDelay": "",*/ "sendAck": "",
                "sendCounts": "", "sendDateStamp": "1", "serialEnabled": "", "sendIoStatus": "1", "tcpPort": -1,
                Baud: 19200, dataBits: 8, Parity: 0, stopBits: 1, serialPort: "AUX"
            }
        };
        _this.savedConfig;
        _this.Version;
        jnrwebsocket.readRegistryKey('AppData/Cinema/$Version', function (registryKey, registryValue) {
            _this.Version = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/IncomingTerminationString', function (registryKey,
            registryValue) {
            _this.config.cinemaServerClientSettings.incomingTerminationString = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/OutgoingTerminationString', function (registryKey,
            registryValue) {
            _this.config.cinemaServerClientSettings.outgoingTerminationString = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Method', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.Method = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/pauseDelay', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.pauseDelay = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/SendAck', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.cinemaServerClientSettings.sendAck = 1;
            }
            if (registryValue == "false") {
                _this.config.cinemaServerClientSettings.sendAck = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/SendCounts', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.cinemaServerClientSettings.sendCounts = 1;
            }
            if (registryValue == "false") {
                _this.config.cinemaServerClientSettings.sendCounts = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/SendDateStamp', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.cinemaServerClientSettings.sendDateStamp = 1;
            }
            if (registryValue == "false") {
                _this.config.cinemaServerClientSettings.sendDateStamp = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/UnsolicitedIoAlerts', function (registryKey,
            registryValue) {
            if (registryValue == "true") {
                _this.config.cinemaServerClientSettings.sendIoStatus = 1;
            }
            if (registryValue == "false") {
                _this.config.cinemaServerClientSettings.sendIoStatus = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/SerialCommandsEnabled', function (registryKey,
            registryValue) {
            if (registryValue == "true") {
                _this.config.cinemaServerClientSettings.serialEnabled = 1;
            }
            if (registryValue == "false") {
                _this.config.cinemaServerClientSettings.serialEnabled = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/TcpPort', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.tcpPort = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Serial/Baud', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.Baud = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Serial/DataBits', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.dataBits = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Serial/Parity', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.Parity = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Serial/StopBits', function (registryKey, registryValue) {
            _this.config.cinemaServerClientSettings.stopBits = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Serial/SerialPort', function (registryKey,
            registryValue) {
            if (registryValue == "AUX") {
                _this.config.cinemaServerClientSettings.serialPort = "AUX";
            }
            if (registryValue == "COM") {
                _this.config.cinemaServerClientSettings.serialPort = "COM";
            }
            if (registryValue == "none") {
                _this.config.cinemaServerClientSettings.serialPort = "none";
            }
            _this.savedConfig = angular.copy(_this.config);
            $scope.$apply();
        });
    });


    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(config, savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/TcpPort',
            _this.config.cinemaServerClientSettings.tcpPort)
        if (_this.config.cinemaServerClientSettings.serialPort == "AUX") {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/SerialPort', "AUX")
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Method', "serial")
        }
        if (_this.config.cinemaServerClientSettings.serialPort == "COM") {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/SerialPort', "COM")
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Method', "serial")
        }
        if (_this.config.cinemaServerClientSettings.serialPort == "none") {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/SerialPort', "none")
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Method', "disabled")
        }
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/Baud',
            _this.config.cinemaServerClientSettings.Baud)
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/DataBits',
            _this.config.cinemaServerClientSettings.dataBits)
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/Parity',
            _this.config.cinemaServerClientSettings.Parity)
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/Serial/StopBits',
            _this.config.cinemaServerClientSettings.stopBits)
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/IncomingTerminationString',
            _this.config.cinemaServerClientSettings.incomingTerminationString)
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/OutgoingTerminationString',
            _this.config.cinemaServerClientSettings.outgoingTerminationString)
        jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/PauseDelay',
            _this.config.cinemaServerClientSettings.pauseDelay)
        if (_this.config.cinemaServerClientSettings.sendAck == 1) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SendAck', true)
        }
        if (_this.config.cinemaServerClientSettings.sendAck == 2) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SendAck', false)
        }
        if (_this.config.cinemaServerClientSettings.sendCounts == 1) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SendCounts', true)
        }
        if (_this.config.cinemaServerClientSettings.sendCounts == 2) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SendCounts', false)
        }
        if (_this.config.cinemaServerClientSettings.sendDateStamp == 1) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SendDateStamp', true)
        }
        if (_this.config.cinemaServerClientSettings.sendDateStamp == 2) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SendDateStamp', false)
        }
        if (_this.config.cinemaServerClientSettings.sendIoStatus == 1) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/UnsolicitedIoAlerts', true)
        }
        if (_this.config.cinemaServerClientSettings.sendIoStatus == 2) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/UnsolicitedIoAlerts', false)
        }
        if (_this.config.cinemaServerClientSettings.serialEnabled == 1) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SerialCommandsEnabled', true)
        }
        if (_this.config.cinemaServerClientSettings.serialEnabled == 2) {
            jnrwebsocket.registryWrite('AppData/Cinema/CinemaServerClient/SerialCommandsEnabled', false)
        }
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    }

}]);