/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class DolbyCP750Ethernet
extends TheatreEthernetDevice {
    private static final String FADER_LEVEL = "cp750.sys.fader ";
    private static final String INPUT_MODE = "cp750.sys.input_mode ";
    private static final String MUTE = "cp750.sys.mute ";

    public DolbyCP750Ethernet(String name) {
        super(name);
        this._port = "61408";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        block16: {
            System.out.println("CP750 macro: " + commandName);
            if (commandName.toLowerCase().startsWith("fader level")) {
                try {
                    String data = commandName.substring(12);
                    commandName = FADER_LEVEL + data + '\r' + '\n';
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Fader Level " + data);
                        break block16;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
            } else if (commandName.toLowerCase().startsWith("input mode")) {
                try {
                    String data = commandName.substring(11);
                    commandName = INPUT_MODE + data + '\r' + '\n';
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Input Mode " + data);
                        break block16;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input Mode");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input Mode");
                }
            } else if (commandName.toLowerCase().startsWith("set mute")) {
                try {
                    String data = commandName.substring(9);
                    commandName = MUTE + data + '\r' + '\n';
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Mute " + data);
                        break block16;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
            } else if (commandName.toLowerCase().startsWith("send")) {
                return super.doSend(commandName);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean send(byte[] dataBytes) {
        if (this.ensureConnection()) {
            try {
                if (dataBytes == null) {
                    System.out.println(this.name + " databytes null");
                }
                System.out.println(this.name + " try to send " + dataBytes.length + " bytes" + HexUtils.hexDump(dataBytes));
                this.bos.reset();
                this.bos.write(dataBytes);
                this.out.write(this.bos.toByteArray());
                return true;
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                try {
                    this.disconnect();
                    if (this.ensureConnection()) {
                        this.out.write(this.bos.toByteArray());
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex1) {
                            FileLogger.error(ex1);
                        }
                        if (this.in.available() <= 0) return true;
                        byte[] inBytes = new byte[128];
                        int bytesRead = this.in.read(inBytes);
                        String bytesBack = bytesRead + " bytes back from cp750";
                        FileLogger.info(Config.DEVICES_LOG, this.name + " " + bytesBack);
                        return true;
                    }
                    this.disconnect();
                    return false;
                }
                catch (IOException ex2) {
                    FileLogger.error(ex2);
                    this.disconnect();
                    return false;
                }
            }
        }
        System.out.println("Could not connect");
        return false;
    }
}

