/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.utils;

import com.integpg.system.JANOS;
import java.io.IOException;

public class ExternalUtils {
    private static final String EXT_DEVICE_ORDER_STRING = "externals/deviceorder";
    private static final String PRESENT_DEVICES_REGISTRY_STRING = "externals/$present";

    public static String getDeviceAddressFor(String typeString, int number) throws IOException {
        int typeCount;
        if (!typeString.startsWith("type")) {
            typeString = String.format("type%s", typeString);
        }
        if (number > (typeCount = ExternalUtils.getDeviceCountForType(typeString))) {
            throw new IOException(String.format("%s_%d is out of bounds", typeString, number));
        }
        String regString = String.format("%s/%s_%d", EXT_DEVICE_ORDER_STRING, typeString, number);
        String addressString = JANOS.getRegistryString((String)regString, null);
        if (null == addressString) {
            throw new IOException(String.format("%s_%d does not exist", typeString, number));
        }
        return addressString;
    }

    public static int getDeviceCountForType(String typeString) {
        String[] deviceRegistryKeys;
        int count = 0;
        if (!typeString.startsWith("type")) {
            typeString = String.format("type%s", typeString);
        }
        for (String deviceRegistryKey : deviceRegistryKeys = JANOS.getRegistryList((String)String.format("%s/%s*", EXT_DEVICE_ORDER_STRING, typeString))) {
            int number = Integer.parseInt(deviceRegistryKey.substring(7));
            if (number <= count) continue;
            count = number;
        }
        return count;
    }

    public static int getIndexForAddress(String addressString) {
        String[] deviceRegistryKeys;
        String typeString = addressString.substring(addressString.length() - 2);
        if (!typeString.startsWith("type")) {
            typeString = String.format("type%s", typeString);
        }
        for (String deviceRegistryKey : deviceRegistryKeys = JANOS.getRegistryList((String)EXT_DEVICE_ORDER_STRING)) {
            String deviceRegistryKeyAddressString = JANOS.getRegistryString((String)String.format("%s/%s", EXT_DEVICE_ORDER_STRING, deviceRegistryKey), (String)typeString);
            if (!deviceRegistryKeyAddressString.equals(addressString)) continue;
            int number = Integer.parseInt(deviceRegistryKey.substring(7));
            return number - 1;
        }
        return -1;
    }

    public static boolean isPresent(String addressString) {
        if (!"".equals(addressString)) {
            String presentDevices = JANOS.getRegistryString((String)PRESENT_DEVICES_REGISTRY_STRING, (String)"");
            return presentDevices.contains(addressString);
        }
        return false;
    }

    public static String getAddressAsString(long deviceAddress) {
        String addressString = "0000000000000000" + Long.toHexString(deviceAddress);
        addressString = addressString.substring(addressString.length() - 16);
        return addressString.toUpperCase();
    }
}

