/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.net.http.HttpConnection;
import com.integpg.janoslib.net.http.HttpResponse;
import com.integpg.janoslib.net.http.HttpURL;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.logger.FileLogger;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class HttpRequest
extends TheatreEthernetDevice {
    public HttpRequest(String name) {
        super(name);
    }

    @Override
    public boolean sendNamedCommand(String commandName) {
        System.out.println("HttpRequest Named Command: " + commandName);
        String[] dataArray = StringUtils.split(commandName, " ");
        String httpMethod = dataArray[0];
        System.out.println("httpMethod = " + httpMethod);
        String resource = null;
        String login = null;
        String data = null;
        byte[] dataBytes = null;
        block10: for (int i = 1; i < dataArray.length; ++i) {
            System.out.println(String.format("%d: %s", i, dataArray[i]));
            switch (dataArray[i]) {
                case "-login": {
                    login = dataArray[++i];
                    continue block10;
                }
                case "-data": {
                    data = dataArray[++i];
                    continue block10;
                }
                default: {
                    resource = dataArray[i];
                }
            }
        }
        System.out.println("resource = " + resource);
        System.out.println("login = " + login);
        System.out.println("data = " + data);
        if (null != data) {
            String converted = this.convertHexToString(data);
            if (converted != null) {
                data = converted;
            }
            if (null == data) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Send aborted: null string");
                return false;
            }
            int dataLen = data.length();
            dataBytes = new byte[dataLen];
            ArrayUtils.arraycopy((Object)data.getBytes(), (int)0, (Object)dataBytes, (int)0, (int)dataLen);
            System.out.println("dataBytes = " + HexUtils.hexDump(dataBytes));
        }
        String urlString = this.buildUrl(login, resource);
        try {
            System.out.println("urlString = " + urlString);
            HttpURL url = new HttpURL(urlString);
            com.integpg.janoslib.net.http.HttpRequest httpPost = new com.integpg.janoslib.net.http.HttpRequest(url);
            httpPost.setRequestMethod(httpMethod);
            httpPost.setDebug(true);
            if (null != dataBytes) {
                httpPost.setData(dataBytes);
            }
            HttpResponse httpResponse = httpPost.sendRequest();
            httpResponse.processResponse();
            String response = httpResponse.getData();
            System.out.println("httpResponse: " + response);
            FileLogger.info(Config.DEVICES_LOG, this.name + " http post response: " + httpResponse.getResponseString());
            return true;
        }
        catch (IOException ex) {
            FileLogger.error(Config.DEVICES_LOG, ex);
            return false;
        }
    }

    @Override
    public boolean login() {
        return false;
    }

    private String buildUrl(String login, String resource) {
        StringBuilder urlStringBuilder = new StringBuilder();
        urlStringBuilder.append("443".equals(this._port) ? "https" : "http");
        urlStringBuilder.append("://");
        if (null != login) {
            urlStringBuilder.append(login);
            urlStringBuilder.append("@");
        }
        urlStringBuilder.append(this._host);
        urlStringBuilder.append(":");
        urlStringBuilder.append(this._port);
        if (null != resource) {
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            urlStringBuilder.append("/");
            urlStringBuilder.append(resource);
        }
        return urlStringBuilder.toString();
    }

    public boolean send(String urlString, String method, byte[] dataBytes) {
        try {
            System.out.println("urlString: " + urlString);
            HttpURL url = new HttpURL(urlString);
            HttpConnection httpConnection = new HttpConnection(url);
            httpConnection.setRequestMethod(method);
            httpConnection.connect();
            httpConnection.sendHeaders();
            httpConnection.sendData();
            httpConnection.close();
            return true;
        }
        catch (IOException ex) {
            FileLogger.error(Config.DEVICES_LOG, ex);
            return false;
        }
    }
}

