/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class NEC_VT700
extends TheatreSerialDevice {
    private static final byte[] POWER_OFF_BYTES = new byte[]{2, 1, 0, 0, 0, 3};
    private static final byte[] POWER_ON_BYTES = new byte[]{2, 0, 0, 0, 0, 2};
    private static final byte[] PICTURE_MUTE_ON_BYTES = new byte[]{2, 16, 0, 0, 0, 18};
    private static final byte[] PICTURE_MUTE_OFF_BYTES = new byte[]{2, 17, 0, 0, 0, 19};

    public NEC_VT700(String name) {
        super(name);
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        System.out.println("NECVT700 macro: " + commandName);
        if (commandName.toLowerCase().equals("picture mute on")) {
            try {
                this.send(PICTURE_MUTE_ON_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Picture Mute On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Picture Mute On");
            }
        } else if (commandName.toLowerCase().equals("picture mute off")) {
            try {
                this.send(PICTURE_MUTE_OFF_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Picture Mute Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Picture Mute Off");
            }
        } else if (commandName.toLowerCase().equals("power on")) {
            try {
                this.send(POWER_ON_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Power On");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power On");
            }
        } else if (commandName.toLowerCase().equals("power off")) {
            try {
                this.send(POWER_OFF_BYTES);
                FileLogger.info(Config.DEVICES_LOG, this.name + " Turning Power Off");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Turning Power Off");
            }
        } else if (commandName.toLowerCase().startsWith("send")) {
            return super.doSend(commandName);
        }
        return true;
    }

    @Override
    public boolean send(byte[] bytes) {
        if (this.serial == null) {
            this.ensureConnection();
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
        return true;
    }

    @Override
    public boolean login() {
        return false;
    }
}

