/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messagepump;

import com.integpg.system.SystemMsg;

public class SystemMsgTypes {
    public static final int SM_SHUTDOWN = 1;
    public static final int SM_PROBE = 2;
    public static final int SM_GCRUN = 16;
    public static final int SM_WATCHDOG = 17;
    public static final int SM_SYSLOG = 18;
    public static final int SM_REGUPDATE = 64;
    public static final int SM_WEBSTARTUP = 96;
    public static final int SM_WEBSHUTDOWN = 97;
    public static final int SM_PROTCMDMSG = 112;
    public static final int SM_PROTCMDRESP = 113;
    public static final int SM_PIPEOPEN = 128;
    public static final int SM_PIPECLOSE = 129;
    public static final int SM_USER = 1024;

    public static String getMessageInfo(SystemMsg systemMsg) {
        switch (systemMsg.type) {
            case 1: {
                return "Shutdown";
            }
            case 2: {
                return "Probe";
            }
            case 16: {
                return "GC Run";
            }
            case 17: {
                return "Watchdog";
            }
            case 18: {
                return "Syslog";
            }
            case 64: {
                return String.format("Registry Update: %s", new String(systemMsg.msg));
            }
            case 96: {
                return "Web Server Startup";
            }
            case 97: {
                return "Web Server Shutdown";
            }
            case 112: {
                return "Protocol Command Message";
            }
            case 113: {
                return "Protocol Command Reesponse";
            }
            case 128: {
                return "Pipe Opened";
            }
            case 129: {
                return "Pipe Closed";
            }
        }
        if (systemMsg.type >= 1024) {
            String dataString = "";
            dataString = 64 >= systemMsg.msg.length ? new String(systemMsg.msg) : String.format("%s...", new String(systemMsg.msg, 0, 64));
            return String.format("User Defined Type: %d: %s", systemMsg.type, dataString);
        }
        return String.format("Unknown Type: %d", systemMsg.type);
    }
}

