/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.logger;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;

public class FileLogger {
    public static final int ALL = 255;
    public static final int DEBUG = 16;
    public static final int INFO = 8;
    public static final int VITAL = 4;
    public static final int WARN = 2;
    public static final int ERROR = 1;
    private static int LEVEL = 255;
    private static final int FILESIZE_IN_KB = 32;

    public static void setDebugLevel(int level) {
        if (level == 255) {
            LEVEL = 255;
            FileLogger.vital("Debug Level Set to ALL");
            return;
        }
        LEVEL = (level << 1) - 1;
        if (LEVEL >= 16) {
            FileLogger.vital("Debug Level Set to DEBUG");
        } else if (LEVEL >= 8) {
            FileLogger.vital("Debug Level Set to INFO");
        } else if (LEVEL >= 4) {
            FileLogger.vital("Debug Level Set to IMPORTANT");
        } else if (LEVEL >= 2) {
            FileLogger.vital("Debug Level Set to WARN");
        } else {
            FileLogger.vital("Debug Level Set to ERROR");
        }
    }

    private static Logger getLog(String filename) {
        Logger log = Logger.getLogger(filename);
        return log;
    }

    private static String fixFilename(String filename) {
        if (!(filename = filename.toLowerCase()).endsWith(".log")) {
            filename = filename + ".log";
        }
        return filename;
    }

    public static void debug(Object obj) {
        AppLog.debug(obj.toString());
    }

    public static void debug(String filename, Object obj) {
        filename = FileLogger.fixFilename(filename);
        Logger log = FileLogger.getLog(filename);
        log.debug(obj.toString());
    }

    public static void info(Object obj) {
        AppLog.info(obj.toString());
    }

    public static void info(String filename, Object obj) {
        filename = FileLogger.fixFilename(filename);
        Logger log = FileLogger.getLog(filename);
        log.info(obj.toString());
    }

    public static void vital(Object obj) {
        AppLog.vital(obj.toString());
    }

    public static void vital(String filename, Object obj) {
        filename = FileLogger.fixFilename(filename);
        Logger log = FileLogger.getLog(filename);
        log.vital(obj.toString());
    }

    public static void warn(Object obj) {
        AppLog.warn(obj.toString());
    }

    public static void warn(String filename, Object obj) {
        filename = FileLogger.fixFilename(filename);
        Logger log = FileLogger.getLog(filename);
        log.warn(obj.toString());
    }

    public static void error(Object obj) {
        if (obj instanceof Exception) {
            Exception ex = (Exception)obj;
            AppLog.error(ex);
        } else {
            AppLog.error(obj.toString());
        }
    }

    public static void error(String errorMessage, Throwable throwable) {
        AppLog.error(errorMessage, throwable);
    }

    public static void error(String filename, Object obj) {
        filename = FileLogger.fixFilename(filename);
        Logger log = FileLogger.getLog(filename);
        log.error(obj.toString());
    }

    public static void error(String filename, String errorMessage, Throwable throwable) {
        filename = FileLogger.fixFilename(filename);
        Logger log = FileLogger.getLog(filename);
        log.error(errorMessage, throwable);
    }
}

