/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.Rebooter;
import com.integpg.cinema.configuration.MacroConfiguration;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroFile;
import com.integpg.cinema.macro.MacroRequestListener;
import com.integpg.cinema.macro.MacroResult;
import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.logger.FileLogger;
import java.util.Vector;

public class MacroExecuter
implements MacroRequestListener {
    private static boolean _macroInProgress;
    private static Vector _macrosInProgress;

    static boolean isMacroInProgress() {
        return _macroInProgress;
    }

    public static void runMacros(MacroRequestListener requester, String macroNamesString) {
        try {
            String[] macroNames;
            for (String macroName : macroNames = StringUtils.split(macroNamesString, ",")) {
                if (macroName.contains(":")) {
                    int colonPos = macroName.indexOf(":");
                    String delayString = macroName.substring(colonPos + 1);
                    delayString = delayString.trim();
                    double delayInSeconds = Double.valueOf(delayString);
                    Thread.sleep((long)(delayInSeconds * 1000.0));
                    macroName = macroName.substring(0, colonPos);
                }
                macroName = macroName.trim();
                MacroExecuter.runMacro(requester, macroName);
            }
        }
        catch (Exception ex) {
            FileLogger.error(Thread.currentThread().getName(), ex);
        }
    }

    public static MacroResult runMacro(MacroRequestListener requester, String macroName) {
        return MacroExecuter.runMacro(requester, macroName, false);
    }

    public static MacroResult runMacro(MacroRequestListener requester, String macroName, boolean checkPreshowLock) {
        FileLogger.info(String.format("run '%s' macro", macroName));
        MacroResult macroResult = new MacroResult();
        try {
            int macroNumber = -1;
            macroName = macroName.toLowerCase();
            try {
                macroNumber = Integer.valueOf(macroName);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (macroNumber == -1) {
                if (CinemaMain.MacroFile.getMacroNames().size() == 0) {
                    macroResult.setReason("no_macros_loaded");
                    macroResult.setResult(false);
                    if (null != requester) {
                        requester.macroResponse(new MacroResult(false, "no_macros_loaded"));
                    }
                } else {
                    Macro macro = (Macro)CinemaMain.MacroFile.getMacroNames().get(macroName);
                    if (null != macro) {
                        macroResult = MacroExecuter.runMacro(requester, macro, checkPreshowLock);
                    }
                }
            } else if (CinemaMain.MacroFile.getMacroNumbers().size() == 0) {
                macroResult.setReason("no_macros_loaded");
                macroResult.setResult(false);
                if (null != requester) {
                    requester.macroResponse(new MacroResult(false, "no_macros_loaded"));
                }
            } else {
                Macro macro = (Macro)CinemaMain.MacroFile.getMacroNumbers().elementAt(macroNumber - 1);
                if (null != macro) {
                    macroResult = MacroExecuter.runMacro(requester, macro, checkPreshowLock);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error executing macro '%s'", macroName), ex);
        }
        return macroResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MacroResult runMacro(final MacroRequestListener requester, final Macro macro, final boolean checkPreshowLock) {
        if (null == macro) {
            throw new IllegalArgumentException("macro cannot be null");
        }
        Object object = MacroFile.getLock();
        synchronized (object) {
            if (CinemaMain.MacroFile.isLoadingFile()) {
                try {
                    System.out.println("wait for macro file lock");
                    MacroFile.getLock().wait();
                    _macroInProgress = true;
                }
                catch (InterruptedException ex) {
                    FileLogger.error("Error locking macro lock in runMacro", ex);
                }
            }
        }
        System.out.println("release macro file lock");
        MacroResult macroResult = new MacroResult();
        if (macro.getName().equalsIgnoreCase("reboot")) {
            MacroExecuter.executeRebootMacro();
        } else {
            boolean isQueueable;
            String macroNameLower = macro.getName().toLowerCase();
            boolean currentlyExecuting = _macrosInProgress.contains(macro);
            if (currentlyExecuting && !(isQueueable = false) && MacroConfiguration.shouldPreventMultipleInstances()) {
                macroResult.setReason("macro_already_in_progress " + macro.getName());
                macroResult.setResult(false);
                FileLogger.info(macroResult.getReason());
                return macroResult;
            }
            try {
                Runnable macroRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            _macrosInProgress.addElement(macro);
                            FileLogger.info(String.format("Starting Macro %s", macro.getName()));
                            macro.setRequester(requester);
                            boolean success = macro.execute(checkPreshowLock);
                            FileLogger.info(String.format("Finished Macro %s", macro.getName()));
                            if (requester != null) {
                                requester.macroResponse(new MacroResult(success, "executed_macro " + macro.getName()).setMacro(macro));
                            }
                        }
                        catch (Exception ex) {
                            FileLogger.error(Thread.currentThread().getName(), ex);
                        }
                        _macrosInProgress.removeElement(macro);
                    }
                };
                ThreadPool.execute(macroRunnable);
                macroResult.setReason("executing");
            }
            catch (RuntimeException ex) {
                FileLogger.error("Too Many Threads trying to start a new Macro", ex);
            }
        }
        Object object2 = MacroFile.getLock();
        synchronized (object2) {
            if (_macrosInProgress.size() == 0) {
                _macroInProgress = false;
                MacroFile.getLock().notifyAll();
            }
        }
        System.out.println("release macro file lock");
        return macroResult;
    }

    @Override
    public void macroResponse(MacroResult macroResult) {
        FileLogger.info("JNIOR Protocol Client " + macroResult.getReason());
    }

    @Override
    public void macroUpdate(Macro macro, String updateString, boolean running) {
    }

    private static void executeRebootMacro() {
        try {
            FileLogger.info("Sending reboot command");
            Rebooter.sendReboot();
        }
        catch (Exception ex) {
            FileLogger.error("error executing reboot macro", ex);
        }
    }

    static {
        _macrosInProgress = new Vector();
    }
}

