/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class DolbyCP850Serial
extends TheatreSerialDevice {
    private static final String FADER_LEVEL = "cp850.sys.fader ";
    private static final String INPUT_MODE = "cp850.sys.input_mode ";
    private static final String MUTE = "cp850.sys.mute ";

    public DolbyCP850Serial(String name) {
        super(name);
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        block16: {
            System.out.println("CP850 macro: " + commandName);
            if (commandName.toLowerCase().startsWith("fader level")) {
                try {
                    commandName = FADER_LEVEL + commandName.substring(12) + "\r";
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Fader Level");
                        break block16;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
            } else if (commandName.toLowerCase().startsWith("input mode")) {
                try {
                    commandName = INPUT_MODE + commandName.substring(11) + "\r";
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Input Mode");
                        break block16;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input Mode");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input Mode");
                }
            } else if (commandName.toLowerCase().startsWith("set mute")) {
                try {
                    commandName = MUTE + commandName.substring(9) + "\r";
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Mute");
                        break block16;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
            } else if (commandName.toLowerCase().startsWith("send")) {
                return super.doSend(commandName);
            }
        }
        return true;
    }

    @Override
    public boolean send(byte[] bytes) {
        if (this.serial == null && !this.ensureConnection()) {
            return false;
        }
        try {
            if (this.out != null) {
                this.out.write(bytes);
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            return false;
        }
        return true;
    }
}

