App.controller('home', ['$scope', function ($scope) {

    var _this = this;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        console.log("macro on load called")
        _this.config = {
            macros: []
        }
        _this.test = {
            Message: 'device.test', Command: "", DataType: "ASCII", IP: "", Port: "", KeepAlive: "false"
        }
        _this.cinemaVersion;
        _this.cinemaDescription;
        _this.portNumber;
        _this.serialPort;
        _this.serialPortType;
        _this.runCinema = false;
        _this.savedConfig;
        var msg = { Message: 'macro.list' };
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/TcpPort', function (registryKey, registryValue) {
            _this.portNumber = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Method', function (registryKey, registryValue) {
            _this.serialPort = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/Cinema/CinemaServerClient/Serial/SerialPort', function (registryKey, registryValue) {
            _this.serialPortType = registryValue;
        });
        jnrwebsocket.readRegistryKey('run/cinema', function (registryKey, registryValue) {
            if (registryValue == "flash/cinema.jar") {
                _this.runCinema = true
            }
            if (registryValue == null) {
                _this.runCinema = false
            }
            _this.savedConfig = _this.runCinema;
        });
        jnrwebsocket.readRegistryKey('Applications/Cinema/Name', function (registryKey, registryValue) {
            _this.cinemaVersion = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/Cinema/Desc', function (registryKey, registryValue) {
            _this.cinemaDescription = registryValue;
        });
        jnrwebsocket.addOnReplyMessageListener(function (data_json) {
            if (data_json.Message == 'macro.list.response') {
                _this.config.macros.length = 0;
                for (var index in data_json.MacroNames) {
                    _this.config.macros.push(data_json.MacroNames[index]);
                }
                $scope.$apply();
            }
        })
        jnrwebsocket.postMessage(2000, msg);
    });

    _this.execute = function (macros) {
        var obj = {Message: 'macro.execute', MacroName: macros};
        jnrwebsocket.postMessage(2000, obj);
    }

    _this.testDevice = function (test) {
        jnrwebsocket.postMessage(2000, test);
    }

    _this.hasChanged = function (runCinema, savedConfig) {
        var hasChanged = !angular.equals(runCinema, savedConfig);
        return hasChanged;
    };

    _this.emptyTestCheck = function () {
        var isEmpty = false;
        var isEmpty = angular.equals(_this.test.Command, "");
        if (isEmpty == true) {
            return isEmpty;
        }
        var isEmpty = angular.equals(_this.test.DataType, "");
        if (isEmpty == true) {
            return isEmpty;
        }
        var isEmpty = angular.equals(_this.test.IP, "");
        if (isEmpty == true) {
            return isEmpty;
        }
        var isEmpty = angular.equals(_this.test.Port, "");
        if (isEmpty == true) {
            return isEmpty;
        }
        var isEmpty = angular.equals(_this.test.KeepAlive, "");
        if (isEmpty == true) {
            return isEmpty;
        }
        return isEmpty;
    };

    _this.writingRegistry = function () {
        if (_this.runCinema) {
            jnrwebsocket.registryWrite('run/cinema', "flash/cinema.jar");
        } else {
            jnrwebsocket.registryWrite('run/cinema', "");
        }
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    }

}]);
