/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreSerialDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class DolbyCP650Serial
extends TheatreSerialDevice {
    private static final byte[] TERMINATION_BYTES = "\r\n".getBytes();
    private static final String FADER_LEVEL = "fader_level=";
    private static final String FADER_SETTING = "fader_setting=";
    private static final String FORMAT_BUTTON = "format_button=";
    private static final String MUTE = "mute=";

    public DolbyCP650Serial(String name) {
        super(name);
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        block21: {
            System.out.println("CP650 macro: " + commandName);
            if (commandName.toLowerCase().startsWith("fader level")) {
                try {
                    commandName = FADER_LEVEL + commandName.substring(12);
                    if (!this.send(commandName.getBytes())) {
                        throw new RuntimeException();
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Fader Level");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader Level");
                }
            } else if (commandName.toLowerCase().startsWith("fader setting")) {
                try {
                    commandName = FADER_SETTING + commandName.substring(14);
                    if (!this.send(commandName.getBytes())) {
                        throw new RuntimeException();
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Adjusting Fader Setting");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader Setting");
                }
            } else if (commandName.toLowerCase().startsWith("format button")) {
                try {
                    commandName = FORMAT_BUTTON + commandName.substring(14);
                    if (!this.send(commandName.getBytes())) {
                        throw new RuntimeException();
                    }
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Format Button");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting  Format Button");
                }
            } else if (commandName.toLowerCase().startsWith("set mute")) {
                try {
                    commandName = MUTE + commandName.substring(9);
                    if (this.send(commandName.getBytes())) {
                        FileLogger.info(Config.DEVICES_LOG, this.name + " Setting Mute");
                        break block21;
                    }
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
                catch (Exception ex) {
                    FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
                }
            } else if (commandName.toLowerCase().startsWith("send")) {
                super.doSend(commandName);
            }
        }
        return true;
    }

    @Override
    public boolean send(byte[] bytes) {
        if (this.serial == null && !this.ensureConnection()) {
            return false;
        }
        try {
            if (this.out != null) {
                this.bos.reset();
                this.bos.write(bytes);
                this.bos.write(TERMINATION_BYTES);
                this.out.write(this.bos.toByteArray());
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
            return false;
        }
        return true;
    }
}

