/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.client.MessageEvent;
import com.integpg.cinema.client.MessageRepeaterListener;
import com.integpg.logger.FileLogger;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class MessageRepeater
extends TimerTask {
    private Timer _timer = null;
    private Date _date;
    private MessageEvent _messageEvent;
    private int _interval;
    private int _repetitions;
    private MessageRepeaterListener _listener;

    public MessageRepeater(Timer timer, MessageRepeaterListener listener) {
        this._timer = timer;
        this._listener = listener;
    }

    public void start(String message, int repetitions, int interval) {
        System.out.println("Setting \"" + message + "\" for " + repetitions + " every " + interval + " seconds");
        this._date = new Date();
        this._messageEvent = new MessageEvent(this, message);
        this._repetitions = repetitions;
        this._interval = interval * 1000;
        this._timer.schedule((TimerTask)this, 0L);
    }

    @Override
    public void run() {
        try {
            if (this._repetitions == -1) {
                return;
            }
            if (this._listener != null) {
                this._listener.messageSendRequest(this._messageEvent);
            }
            if (this._repetitions == 0 || --this._repetitions > 0) {
                this._date.setTime(this._date.getTime() + (long)this._interval);
                this._timer.schedule((TimerTask)this, this._date);
            }
        }
        catch (Exception ex) {
            FileLogger.error(ex);
        }
    }
}

