/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.Config;
import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.logger.FileLogger;
import java.io.IOException;

public class Jsd100Ethernet
extends TheatreEthernetDevice {
    private static final String FADER = "jsd100.sys.fader\t";
    private static final String FADER_RELATIVE = "jsd100.sys.fader_rel\t";
    private static final String INPUT_MODE = "jsd100.sys.input_mode\t";
    private static final String MUTE = "jsd100.sys.mute\t";

    public Jsd100Ethernet(String name) {
        super(name);
        this._port = "5000";
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public synchronized boolean sendNamedCommand(String commandName) {
        System.out.println("Jsd100 macro: " + commandName);
        if (commandName.toLowerCase().startsWith("set fader")) {
            try {
                commandName = FADER + commandName.substring(10) + "\r";
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Fader Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Fader");
            }
        } else if (commandName.toLowerCase().startsWith("adjust fader")) {
            try {
                commandName = FADER_RELATIVE + commandName.substring(13) + "\r";
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Fader Adjusted");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Adjusting Fader");
            }
        } else if (commandName.toLowerCase().startsWith("set input")) {
            try {
                commandName = INPUT_MODE + commandName.substring(10) + "\r";
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Input Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Input");
            }
        } else if (commandName.toLowerCase().startsWith("set mute")) {
            try {
                commandName = MUTE + commandName.substring(9) + "\r";
                if (this.send(commandName.getBytes())) {
                    FileLogger.info(Config.DEVICES_LOG, this.name + " Mute Set");
                    return true;
                }
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
            }
            catch (Exception ex) {
                FileLogger.error(Config.DEVICES_LOG, this.name + " Error Setting Mute");
            }
        } else if (commandName.toLowerCase().startsWith("send")) {
            return super.doSend(commandName);
        }
        return false;
    }

    @Override
    public synchronized boolean send(byte[] dataBytes) {
        if (this.ensureConnection()) {
            try {
                if (dataBytes == null) {
                    System.out.println(this.name + " databytes null");
                }
                this.bos.reset();
                this.bos.write(dataBytes);
                this.out.write(this.bos.toByteArray());
            }
            catch (IOException ex) {
                FileLogger.error(ex);
                try {
                    this.disconnect();
                    if (!this.ensureConnection()) {
                        this.disconnect();
                        return false;
                    }
                    this.out.write(this.bos.toByteArray());
                }
                catch (IOException ex2) {
                    FileLogger.error(ex2);
                    this.disconnect();
                    return false;
                }
            }
        } else {
            System.out.println("Could not connect");
            return false;
        }
        return true;
    }
}

