/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.client;

import com.integpg.cinema.AssemblyInfo;
import com.integpg.cinema.CinemaMain;
import com.integpg.cinema.client.PreshowClient;
import com.integpg.cinema.client.PreshowClientHandler;
import com.integpg.janoslib.net.tcp.TcpServer;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.logger.FileLogger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class PreshowClientTcpServer
implements TcpServerListener {
    private final PreshowClient m_parent;
    private final int m_port;
    private final Vector clients = new Vector();
    private TcpServer _tcpServer;

    public PreshowClientTcpServer(PreshowClient parent, int port) {
        this.m_parent = parent;
        this.m_port = port;
    }

    public void removeClientHandler(PreshowClientHandler handler) {
        if (this.clients.contains(handler)) {
            this.clients.removeElement(handler);
        }
    }

    public int getPort() {
        return this._tcpServer.getPort();
    }

    public void start() {
        try {
            this._tcpServer = new TcpServer("Preshow Client TCP Server", this.m_port);
            this._tcpServer.setTcpServerListener(this);
            this._tcpServer.start();
        }
        catch (Exception ex) {
            FileLogger.error(ex);
            JANOS.logfile((String)"errors.log", (String)String.format("[%s] %s", AssemblyInfo.getName(), ex.getMessage()));
        }
    }

    public void stop() throws IOException {
        this._tcpServer.stop();
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        try {
            Socket socket = evt.getSocket();
            System.out.println("Client connected");
            PreshowClientHandler handler = new PreshowClientHandler(this.m_parent, socket.getInputStream(), socket.getOutputStream(), socket, this);
            this.clients.addElement(handler);
            Thread thd = new Thread((Runnable)handler, "Preshow Client Handler");
            thd.start();
            try {
                CinemaMain.ProtocolCommandMonitor.setLocalHook("90SecondTimer", handler);
                FileLogger.info("Register InterProcess 90 Second Timer Command");
            }
            catch (Exception ex) {
                FileLogger.error(ex);
            }
        }
        catch (IOException ex) {
            FileLogger.error(ex);
        }
        catch (Exception ex) {
            FileLogger.error(ex);
        }
    }

    void send(String message) throws IOException {
        Enumeration elements = this.clients.elements();
        while (elements.hasMoreElements()) {
            PreshowClientHandler handler = (PreshowClientHandler)elements.nextElement();
            handler.send(message);
        }
    }

    public void pauseReceivedFromCinemaServer() {
        Enumeration elements = this.clients.elements();
        while (elements.hasMoreElements()) {
            PreshowClientHandler handler = (PreshowClientHandler)elements.nextElement();
            handler.pauseReceivedFromCinemaServer();
        }
    }

    public void timerConfigUpdated() {
        Enumeration elements = this.clients.elements();
        while (elements.hasMoreElements()) {
            PreshowClientHandler handler = (PreshowClientHandler)elements.nextElement();
            handler.timerConfigUpdated();
        }
    }
}

