/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.macro;

import com.integpg.cinema.client.JsonClientHandler;
import com.integpg.cinema.devices.XChangeDevice;
import com.integpg.cinema.macro.Macro;
import com.integpg.cinema.macro.MacroExecuter;
import com.integpg.cinema.messaging.MacroListResponseSystemMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.logger.FileLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MacroFile {
    private String _macroFile = null;
    private Hashtable _macroNames = new Hashtable();
    private Vector _macroNumbers = new Vector();
    private long _lastMacroFileModification;
    private static final Object Lock = new Object();
    private boolean _loadingMacroFile;

    static Object getLock() {
        return Lock;
    }

    boolean isLoadingFile() {
        return this._loadingMacroFile;
    }

    public Hashtable getMacroNames() {
        return this._macroNames;
    }

    public Vector getMacroNumbers() {
        return this._macroNumbers;
    }

    public String getMacroFile() {
        return this._macroFile;
    }

    public long getLastModified() {
        return this._lastMacroFileModification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadMacroFile(String macroFile) throws FileNotFoundException, IOException {
        if (macroFile == null) {
            return;
        }
        Object object = Lock;
        synchronized (object) {
            if (MacroExecuter.isMacroInProgress()) {
                try {
                    Lock.wait();
                }
                catch (InterruptedException ex) {
                    FileLogger.error("Error locking macro lock while macro in progress", ex);
                }
            }
            this._loadingMacroFile = true;
        }
        System.out.println("release macro file lock");
        FileLogger.info("Loading Macro File " + macroFile + " published " + new Date(new File(macroFile).lastModified()));
        this._macroNames = new Hashtable();
        this._macroNumbers = new Vector();
        int DEVICES = 1;
        int ACTIONS = 2;
        int DATA = 3;
        int MACROS = 4;
        BufferedReader br = new BufferedReader(new FileReader(new File(macroFile)));
        int state = 0;
        int commandsLength = 200;
        String[] commands = new String[commandsLength];
        for (int i = 0; i < commandsLength; ++i) {
            commands[i] = "";
        }
        int devicesLength = 200;
        String[] devices = new String[devicesLength];
        for (int i = 0; i < devicesLength; ++i) {
            devices[i] = "";
        }
        int actionsLength = 200;
        String[] actions = new String[actionsLength];
        for (int i = 0; i < actionsLength; ++i) {
            actions[i] = "";
        }
        int dataLength = 200;
        String[] data = new String[dataLength];
        for (int i = 0; i < dataLength; ++i) {
            data[i] = "";
        }
        Macro macro = null;
        String macroName = null;
        int macroCount = 0;
        boolean lineCount = true;
        block30: while (true) {
            String s;
            StringTokenizer st;
            int col;
            block61: {
                String line;
                if ((line = br.readLine()) == null) {
                    br.close();
                    FileLogger.info("Macro File Loaded");
                    XChangeDevice.getInstance().sendMacros(null);
                    this._lastMacroFileModification = new File(macroFile).lastModified();
                    this._macroFile = macroFile;
                    System.out.println("Time spent adding " + Macro.TotalActions + " actions " + Macro.TotalTime);
                    JsonClientHandler.updateMacroList();
                    Object ex = Lock;
                    synchronized (ex) {
                        this._loadingMacroFile = false;
                        Lock.notifyAll();
                    }
                    System.out.println("release macro file lock");
                    MacroListResponseSystemMessage systemMsg = new MacroListResponseSystemMessage().build();
                    MessagePumpEngine.postMessage(systemMsg);
                    return;
                }
                try {
                    if (state == 0 && !line.startsWith("Device")) continue;
                    col = 0;
                    st = new StringTokenizer(line, ",", true);
                    try {
                        s = st.nextToken();
                        break block61;
                    }
                    catch (NoSuchElementException ex) {
                        FileLogger.error(ex);
                    }
                }
                catch (Exception ex) {
                    FileLogger.error(ex);
                }
                continue;
            }
            while (true) {
                if (s.equals(",") && st.hasMoreTokens()) {
                    try {
                        s = st.nextToken();
                    }
                    catch (NoSuchElementException ex) {
                        FileLogger.error("Error loading macro file", ex);
                        return;
                    }
                    ++col;
                    continue;
                }
                if (s.equals(",")) continue block30;
                if (col == 0) {
                    if (col == 0 && s.equalsIgnoreCase("data")) {
                        state = DATA;
                        try {
                            s = st.nextToken();
                        }
                        catch (NoSuchElementException ex) {
                            FileLogger.error("Error loading macro file", ex);
                            return;
                        }
                    }
                    if (col == 0 && s.equalsIgnoreCase("macro name")) {
                        break;
                    }
                    if (col == 0 && s.equalsIgnoreCase("device")) {
                        state = DEVICES;
                        try {
                            s = st.nextToken();
                        }
                        catch (NoSuchElementException ex) {
                            FileLogger.error("Error loading macro file", ex);
                            return;
                        }
                    }
                    if (col == 0 && s.equalsIgnoreCase("action")) {
                        state = ACTIONS;
                        try {
                            s = st.nextToken();
                        }
                        catch (NoSuchElementException ex) {
                            FileLogger.error("Error loading macro file", ex);
                            return;
                        }
                    }
                }
                if (state != 0 || col <= 0) {
                    if (state == DEVICES) {
                        devices[col - 1] = s.trim();
                    } else if (state == ACTIONS) {
                        actions[col - 1] = s.trim();
                    } else if (state == DATA) {
                        if (0 < s.indexOf("\"")) {
                            int numberOfQuotes = 0;
                            int stringPosition = 0;
                            int nextQuotePosition = s.indexOf("\"", stringPosition);
                            while (-1 != nextQuotePosition) {
                                stringPosition = nextQuotePosition + 1;
                                if (-1 != (nextQuotePosition = s.indexOf("\"", stringPosition)) || 1 != ++numberOfQuotes % 2) continue;
                                s = s + "," + st.nextToken();
                                nextQuotePosition = s.indexOf("\"", stringPosition);
                            }
                        }
                        data[col - 1] = s.trim();
                    } else if (state == MACROS) {
                        if (col == 0) {
                            macro = new Macro(s);
                            macroName = s;
                            FileLogger.info(++macroCount + ": Loading Macro: " + s);
                            this._macroNames.put(macroName.toLowerCase(), macro);
                            this._macroNumbers.addElement(macro);
                        } else if (!s.equals("")) {
                            try {
                                double d = new Double(s);
                                macro.addAction((int)(d * 1000.0), commands[col - 1]);
                            }
                            catch (NumberFormatException ex) {
                                FileLogger.error("Error loading macro file", ex);
                            }
                        }
                    }
                }
                if (!st.hasMoreTokens()) continue block30;
                try {
                    s = st.nextToken();
                }
                catch (NoSuchElementException ex) {
                    FileLogger.error("Error loading macro file", ex);
                    return;
                }
            }
            for (col = 1; col < commands.length; ++col) {
                boolean isJniorPort;
                if (devices[col - 1] == null || devices[col - 1].equals("")) continue;
                int jniorOffset = 0;
                if (devices[col - 1].startsWith("DIN")) {
                    jniorOffset = 3;
                } else if (devices[col - 1].startsWith("ROUT")) {
                    jniorOffset = 4;
                }
                boolean bl = isJniorPort = jniorOffset > 0;
                if (isJniorPort) {
                    int port = 0;
                    try {
                        port = Integer.parseInt(devices[col - 1].substring(jniorOffset).trim());
                        isJniorPort = true;
                    }
                    catch (NumberFormatException ex) {
                        FileLogger.error(devices[col - 1] + " is Not JNIOR port", ex);
                    }
                    s = port > 16 ? actions[col - 1] + "++" + (port - 16) : (port > 8 ? actions[col - 1] + "+" + (port - 8) : actions[col - 1] + port);
                    if (actions[col - 1].toLowerCase().equals("cp") || actions[col - 1].toLowerCase().equals("sp")) {
                        try {
                            if ("".equals(data[col - 1])) {
                                data[col - 1] = "1";
                            }
                            double d = Double.valueOf(data[col - 1]);
                            s = s + "=" + (int)(d * 1000.0);
                        }
                        catch (Exception ex) {
                            FileLogger.error("error consuming close pulse or soft pulse", ex);
                        }
                    }
                    commands[col - 1] = s;
                    continue;
                }
                s = "device_";
                s = actions[col - 1].equals("Send Macro") ? s + devices[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Input Switch") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Set Fader") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Adjust Fader") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Fader Level") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Fader Setting") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Format Button") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Set Input") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Input Mode") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Set Mute") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (devices[col - 1].toLowerCase().startsWith("fpled") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (devices[col - 1].toLowerCase().startsWith("fpsound") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].toLowerCase().indexOf("intermission") != -1 ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("active audio preset") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("active control preset") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("master gain") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("master mute") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equalsIgnoreCase("master amp power on") ? s + devices[col - 1] + " " + actions[col - 1] + " " + data[col - 1] : (actions[col - 1].equals("Send") ? s + devices[col - 1] + " send " + data[col - 1] : (actions[col - 1].equals("GET") ? s + devices[col - 1] + " GET " + data[col - 1] : (actions[col - 1].equals("PUT") ? s + devices[col - 1] + " PUT " + data[col - 1] : (actions[col - 1].equals("POST") ? s + devices[col - 1] + " POST " + data[col - 1] : s + devices[col - 1] + " " + actions[col - 1])))))))))))))))))))));
                commands[col - 1] = s;
            }
            state = MACROS;
        }
    }
}

