/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.cinema.devices;

import com.integpg.cinema.devices.TheatreEthernetDevice;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.logger.FileLogger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class RawUdp
extends TheatreEthernetDevice {
    public RawUdp(String name) {
        super(name);
    }

    public synchronized boolean macroExecute(String commandName) {
        try {
            String newTermString = "";
            boolean backslashFound = false;
            if (this.terminationString != null) {
                for (int i = 0; i < this.terminationString.length(); ++i) {
                    if (this.terminationString.charAt(i) == '\\' && !backslashFound) {
                        backslashFound = true;
                        continue;
                    }
                    if (backslashFound) {
                        switch (this.terminationString.charAt(i)) {
                            case 'r': {
                                newTermString = newTermString + '\r';
                                break;
                            }
                            case 'n': {
                                newTermString = newTermString + '\n';
                                break;
                            }
                            case 't': {
                                newTermString = newTermString + '\t';
                                break;
                            }
                            case 'f': {
                                newTermString = newTermString + '\f';
                                break;
                            }
                            case 'b': {
                                newTermString = newTermString + '\b';
                                break;
                            }
                            case '0': {
                                newTermString = newTermString + '\u0000';
                            }
                        }
                    } else {
                        newTermString = newTermString + this.terminationString.charAt(i);
                    }
                    backslashFound = false;
                }
            }
            if (commandName.startsWith("send")) {
                return super.doSend(commandName);
            }
        }
        catch (RuntimeException ex) {
            FileLogger.error("Cinema.jnior: Raw Ethernet Execute macro Too Many Threads.", ex);
        }
        return true;
    }

    @Override
    public boolean send(byte[] bytes) {
        System.out.println("udp send: " + HexUtils.bytesToHex(bytes));
        try {
            InetAddress address = InetAddress.getByName(this._host);
            DatagramSocket ds = new DatagramSocket();
            DatagramPacket dp = new DatagramPacket(bytes, bytes.length, address, Integer.parseInt(this._port));
            ds.send(dp);
            Thread.sleep(500L);
            ds.close();
        }
        catch (Exception ex) {
            FileLogger.error("Error sending UDP in raw ethernet: " + ex.getMessage());
        }
        return true;
    }

    @Override
    public boolean login() {
        return false;
    }

    @Override
    public boolean sendNamedCommand(String commandName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

